% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{SE_from_p}
\alias{SE_from_p}
\title{Compute an SE from a beta and p value}
\usage{
SE_from_p(beta = NULL, p = NULL, SE = NULL, lower = NULL, upper = NULL)
}
\arguments{
\item{beta}{The effect size}

\item{p}{The p-value for the effect}

\item{SE}{Standard error}

\item{lower}{Lower CI}

\item{upper}{Upper CI}
}
\value{
\itemize{
\item Standard error
}
}
\description{
\code{SE_from_p} takes beta and p, and returns an SE.
}
\examples{
SE_from_p(beta = .0020, p = .780)
SE_from_p(beta = .0020, p = .01)
SE_from_p(beta = .0020, SE = 0.01)
umxAPA(.0020, p = .01)
}
\seealso{
\itemize{
\item \code{\link[=umxAPA]{umxAPA()}}
}

Other Miscellaneous Stats Functions: 
\code{\link{FishersMethod}()},
\code{\link{geometric_mean}()},
\code{\link{harmonic_mean}()},
\code{\link{oddsratio}()},
\code{\link{reliability}()},
\code{\link{umxCov2cor}()},
\code{\link{umxHetCor}()},
\code{\link{umxWeightedAIC}()},
\code{\link{umx_apply}()},
\code{\link{umx_cor}()},
\code{\link{umx_means}()},
\code{\link{umx_r_test}()},
\code{\link{umx_round}()},
\code{\link{umx_scale}()},
\code{\link{umx_var}()},
\code{\link{umx}}
}
\concept{Miscellaneous Stats Functions}
