% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_file_load_pseudo}
\alias{umx_file_load_pseudo}
\title{Read in files from pseudocons.}
\usage{
umx_file_load_pseudo(fn, bp, suffix = "_NT", chosenp = "S5")
}
\arguments{
\item{fn}{The filename}

\item{bp}{The path to the folder containing the file}

\item{suffix}{to add to the NT columns (Default = "_NT")}

\item{chosenp}{The suffix (pvalue) we desire to use (Default = "S5")}
}
\value{
\itemize{
\item dataframe of real and pseudo PRS columns
}
}
\description{
Read in PRS scored files from \href{https://www.staff.ncl.ac.uk/richard.howey/pseudocons/example.html}{pseudocons}.
\enumerate{
\item Read the file
\item Break it into pseudo and real rows
\item Clean-up by deleting the pseudo suffix
\item Rename NT vars with a suffix
\item Merge files on ID and return
}\tabular{llrrrrrl}{
    \tab ID \tab FID \tab BMIS1 \tab BMIS2 \tab BMIS3 \tab BMIS4 \tab ... \cr
   1 \tab 1234501 \tab 12345 \tab -0.032 \tab -0.77 \tab -0.40 \tab -3.87 \tab ... \cr
   2 \tab 1234501-pseudo-1 \tab 12345 \tab 0.117 \tab -0.66 \tab -0.33 \tab -4.08 \tab ... \cr
}
}
\examples{
\dontrun{
basepath = "~/Dropbox/2016 (1). project EA/2018/EA3/"
tmp = umx_file_load_pseudo("PRS_EA3_R9_autosomes_HRC1.1_pseudo.txt", bp = bp)
str(tmp)
head(tmp[, c("BMIS4", "BMIS4_NT")]
}
}
\seealso{
Other File Functions: 
\code{\link{dl_from_dropbox}()},
\code{\link{umx_make_sql_from_excel}()},
\code{\link{umx_move_file}()},
\code{\link{umx_open}()},
\code{\link{umx_rename_file}()},
\code{\link{umx_write_to_clipboard}()},
\code{\link{umx}}
}
\concept{File Functions}
