% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umxDoCbyPath.R
\name{umxDoCp}
\alias{umxDoCp}
\title{Make a direction of causation model based on umxPath statements}
\usage{
umxDoCp(
  var1Indicators,
  var2Indicators,
  mzData = NULL,
  dzData = NULL,
  sep = "_T",
  causal = TRUE,
  name = "DoC",
  autoRun = getOption("umx_auto_run"),
  intervals = FALSE,
  tryHard = c("no", "yes", "ordinal", "search"),
  optimizer = NULL
)
}
\arguments{
\item{var1Indicators}{The indicators of trait 1}

\item{var2Indicators}{The indicators of trait 2}

\item{mzData}{The MZ twin dataframe}

\item{dzData}{The DZ twin dataframe}

\item{sep}{(Default "_T")}

\item{causal}{(Default TRUE)}

\item{name}{= "DoC"}

\item{autoRun}{Default: getOption("umx_auto_run")_}

\item{intervals}{Whether to run intervals (Default FALSE)}

\item{tryHard}{Default "no" (valid = "yes", "ordinal", "search")}

\item{optimizer}{Whether to set this for this run (Default no))}
}
\value{
\itemize{
\item [A direction of causation model with \code{\link[=umxPath]{umxPath()}} statements.
}
}
\description{
Makes a direction of causation model with \code{\link[=umxPath]{umxPath()}} statements
}
\details{
See also \code{\link[=umxDoC]{umxDoC()}}
}
\examples{
\dontrun{
# ================
# = 1. Load Data =
# ================
data(docData)
var1 = paste0("varA", 1:3)
var2 = paste0("varB", 1:3)
tmp = umx_scale_wide_twin_data(varsToScale= c(var1, var2), sep= "_T", data= docData)
mzData = subset(docData, zygosity \%in\% c("MZFF", "MZMM"))
dzData = subset(docData, zygosity \%in\% c("DZFF", "DZMM"))
m1 = umxDoCp(var1, var2, mzData= mzData, dzData= dzData, sep = "_T", causal= TRUE)

}
}
\seealso{
\itemize{
\item \code{\link[=umxDoC]{umxDoC()}}
}

Other Twin Modeling Functions: 
\code{\link{plot.MxModelTwinMaker}()},
\code{\link{power.ACE.test}()},
\code{\link{umxACEcov}()},
\code{\link{umxACEv}()},
\code{\link{umxACE}()},
\code{\link{umxCP}()},
\code{\link{umxDoC}()},
\code{\link{umxGxE_window}()},
\code{\link{umxGxEbiv}()},
\code{\link{umxGxE}()},
\code{\link{umxIP}()},
\code{\link{umxRotate.MxModelCP}()},
\code{\link{umxSexLim}()},
\code{\link{umxSimplex}()},
\code{\link{umx}}
}
\concept{Twin Modeling Functions}
