% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{Fischbein_wt}
\alias{Fischbein_wt}
\title{Weight data across time.}
\format{A 6*6 correlation matrix based on n = 66 females}
\usage{
data(Fischbein_wt)
}
\description{
A dataframe containing correlations of weight for 66 females measured 6 times at 6-month intervals.
}
\details{
\itemize{
\item Weight1: Weight at time 1 (t0)
\item Weight2: Weight at time 2 (t0 + 6 months)
\item Weight3: Weight at time 3 (t0 + 12 months)
\item Weight4: Weight at time 4 (t0 + 18 months)
\item Weight5: Weight at time 5 (t0 + 24 months)
\item Weight6: Weight at time 6 (t0 + 32 months)
}

Created as follows:\preformatted{Fischbein_wt = umx_read_lower(file = "", diag = TRUE, names = paste0("Weight", 1:6), ensurePD= TRUE)
1.000
0.985	1.000
0.968	0.981	1.000
0.957	0.970	0.985	1.000
0.932	0.940	0.964	0.975	1.000
0.890	0.897	0.927	0.949	0.973	1.000
}
}
\examples{
data(Fischbein_wt) # load the data
str(Fischbein_wt) # data.frame
as.matrix(Fischbein_wt) # convert to matrix
}
\references{
Fischbein, S. (1977). Intra-pair similarity in physical growth of monozygotic and of dizygotic twins during puberty. \emph{Annals of Human Biology}, \strong{4}. 417-430.
\url{https://doi.org/10.1080/03014467700002401}
}
\seealso{
Other datasets: \code{\link{GFF}}, \code{\link{iqdat}},
  \code{\link{umx}}, \code{\link{us_skinfold_data}}
}
\concept{datasets}
\keyword{datasets}
