% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_set_plot_file_suffix}
\alias{umx_set_plot_file_suffix}
\title{Set output suffix used in umx plot (structural diagrams) files to disk}
\usage{
umx_set_plot_file_suffix(umx.plot.suffix = NULL, silent = FALSE)
}
\arguments{
\item{umx.plot.suffix}{the suffix for plots files (if empty, returns the current value of umx.plot.format). If "TRUE", then toggles}

\item{silent}{If TRUE, no message will be printed.}
}
\value{
- Current umx.plot.suffix setting
}
\description{
Set output file suffix (default = "gv", alternative is "dot"). If you call this with no
value, it will return the current setting. If you call it with TRUE, it toggles the setting.
}
\examples{
umx_set_plot_file_suffix() # print current state
old = umx_set_plot_file_suffix(silent = TRUE) # store current value
umx_set_plot_file_suffix("dot")
umx_set_plot_file_suffix("gv")
umx_set_plot_file_suffix(old) # reinstate
}
\references{
- \url{https://tbates.github.io}, \url{https://github.com/tbates/umx}
}
\seealso{
Other Get and set: \code{\link{umx_default_option}},
  \code{\link{umx_get_checkpoint}},
  \code{\link{umx_get_options}},
  \code{\link{umx_set_auto_plot}},
  \code{\link{umx_set_auto_run}},
  \code{\link{umx_set_checkpoint}},
  \code{\link{umx_set_condensed_slots}},
  \code{\link{umx_set_cores}},
  \code{\link{umx_set_optimization_options}},
  \code{\link{umx_set_optimizer}},
  \code{\link{umx_set_plot_format}},
  \code{\link{umx_set_table_format}}, \code{\link{umx}}
}
\concept{Get and set}
