% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxReduce}
\alias{umxReduce}
\title{Reduce models, and report the results.}
\usage{
umxReduce(model, report = c("markdown", "inline", "html", "report"),
  baseFileName = "tmp", ...)
}
\arguments{
\item{model}{The \code{\link{mxModel}} which will be reduced.}

\item{report}{How to report the results. "html" = open in browser}

\item{baseFileName}{(optional) custom filename for html output (defaults to "tmp")}

\item{...}{Other parameters to control model summary}
}
\description{
Given an OpenMx model (currently ACE and GxE are supported - ask for more!)
umxReduce will conduct a formalised reduction process

\strong{GxE model reduction}
For \code{\link{umxGxE}} models, each form of moderation is tested
on its own, and jointly.
Also, C is removed, and moderation tested in this model.

\strong{ACE model reduction}
For \code{\link{umxACE}} models, each form of moderation is tested on its own, and jointly.
Also, C is removed, and moderation tested in this model.

It reports the results in a table. Set the format of the table with
\code{\link{umx_set_table_format}}()., or set `report` to "html" to open a
table for pasting into a word processor.

umxReduce is a work in progress, with more automations coming as demand emerges.
I am thinking for RAM models to drop NS paths, and report that test.
}
\seealso{
Other Reporting Functions: \code{\link{loadings.MxModel}},
  \code{\link{tmx_is.identified}}, \code{\link{umxAPA}},
  \code{\link{umxEval}}, \code{\link{umxFactorScores}},
  \code{\link{umxGetParameters}}, \code{\link{umxSummary}},
  \code{\link{umx_APA_model_CI}},
  \code{\link{umx_APA_pval}}, \code{\link{umx_aggregate}},
  \code{\link{umx_names}}, \code{\link{umx_parameters}},
  \code{\link{umx_print}},
  \code{\link{umx_show_fit_or_comparison}},
  \code{\link{umx_show}}, \code{\link{umx_time}},
  \code{\link{umx}}
}
