% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{extractAIC.MxModel}
\alias{extractAIC.MxModel}
\title{Extract AIC from MxModel}
\usage{
\method{extractAIC}{MxModel}(fit, scale, k, ...)
}
\arguments{
\item{fit}{an fitted \code{\link{mxModel}} from which to get the AIC}

\item{scale}{not used}

\item{k}{not used}

\item{...}{any other parameters (not used)}
}
\value{
- AIC value
}
\description{
Returns the AIC for an OpenMx model.
Original Author: Brandmaier
}
\examples{
require(umx)
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
m1 <- umxRAM("One Factor", data = mxData(cov(demoOneFactor), type = "cov", numObs = 500),
	umxPath(latents, to = manifests),
	umxPath(var = manifests),
	umxPath(var = latents, fixedAt = 1)
)
extractAIC(m1)
# -2.615998
AIC(m1)
}
\references{
- \url{http://openmx.ssri.psu.edu/thread/931#comment-4858}
}
\seealso{
- \code{\link{AIC}}, \code{\link{umxCompare}}, \code{\link{logLik}}

Other Reporting functions: \code{\link{RMSEA.MxModel}},
  \code{\link{RMSEA.summary.mxmodel}}, \code{\link{RMSEA}},
  \code{\link{loadings}}, \code{\link{residuals.MxModel}},
  \code{\link{umxCI_boot}}, \code{\link{umxCI}},
  \code{\link{umxCompare}}, \code{\link{umxConfint}},
  \code{\link{umxExpCov}}, \code{\link{umxExpMeans}},
  \code{\link{umxFitIndices}}, \code{\link{umxPlotACEv}},
  \code{\link{umxSummary.MxModel}},
  \code{\link{umxSummaryACEv}},
  \code{\link{umxSummaryACE}},
  \code{\link{umxSummarySexLim}},
  \code{\link{umxSummarySimplex}},
  \code{\link{umx_drop_ok}},
  \code{\link{umx_standardize_RAM}}
}
