% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xmu_make_top_twin_models.R
\name{xmu_starts}
\alias{xmu_starts}
\title{Helper providing twin models with boilerplate means and variance start values}
\usage{
xmu_starts(mzData, dzData, selVars = selVars, sep = NULL,
  equateMeans = NULL, nSib = 2, varForm = c("Cholesky"), SD = TRUE,
  divideBy = 3)
}
\arguments{
\item{mzData}{Data for MZ pairs.}

\item{dzData}{Data for DZ pairs.}

\item{selVars}{Variable names: If sep = NULL, then treated as full names for both sibs.}

\item{sep}{All the variables full names.}

\item{equateMeans}{(NULL)}

\item{nSib}{How many subjects in a family.}

\item{varForm}{currently just "Cholesky" style.}

\item{SD}{= TRUE (FALSE = variance, not SD).}

\item{divideBy}{= 3 (A,C,E) 1/3rd each. Use 1 to do this yourself post-hoc.}
}
\value{
\itemize{
\item varStarts and meanStarts
}
}
\description{
\code{xmu_starts} can handle several common/boilerplate situations in which means and variance start values
are used in twin models.
}
\examples{
data(twinData)
selDVs = c("wt", "ht")
mzData = twinData[twinData$zygosity \%in\%  "MZFF", ] 
dzData = twinData[twinData$zygosity \%in\%  "DZFF", ]
round(sqrt(var(dzData[,tvars(selDVs, "")], na.rm=TRUE)/3),3)
tmp = xmu_starts(mzData, dzData, selVars = selDVs, sep= "", 
	equateMeans = TRUE, varForm = "Cholesky")
tmp
round(var(dzData[,tvars(selDVs, "")], na.rm=TRUE)/3,3)
tmp = xmu_starts(mzData, dzData, selVars = selDVs, sep= "", 
	equateMeans = TRUE, varForm = "Cholesky", SD=FALSE)
tmp
# one variable
tmp = xmu_starts(mzData, dzData, selVars = "wt", sep= "", 
	equateMeans = TRUE, varForm = "Cholesky", SD= FALSE)
}
\seealso{
Other xmu internal not for end user: \code{\link{umxModel}},
  \code{\link{umx}}, \code{\link{xmuHasSquareBrackets}},
  \code{\link{xmuLabel_MATRIX_Model}},
  \code{\link{xmuLabel_Matrix}},
  \code{\link{xmuLabel_RAM_Model}}, \code{\link{xmuMI}},
  \code{\link{xmuMakeDeviationThresholdsMatrices}},
  \code{\link{xmuMakeOneHeadedPathsFromPathList}},
  \code{\link{xmuMakeTwoHeadedPathsFromPathList}},
  \code{\link{xmuMaxLevels}}, \code{\link{xmuMinLevels}},
  \code{\link{xmuPropagateLabels}},
  \code{\link{xmu_assemble_twin_supermodel}},
  \code{\link{xmu_check_levels_identical}},
  \code{\link{xmu_clean_label}},
  \code{\link{xmu_dot_make_paths}},
  \code{\link{xmu_dot_make_residuals}},
  \code{\link{xmu_dot_maker}},
  \code{\link{xmu_dot_move_ranks}},
  \code{\link{xmu_dot_rank_str}},
  \code{\link{xmu_lavaan_process_group}},
  \code{\link{xmu_make_mxData}},
  \code{\link{xmu_make_top_twin}},
  \code{\link{xmu_model_needs_means}},
  \code{\link{xmu_safe_run_summary}},
  \code{\link{xmu_set_sep_from_suffix}},
  \code{\link{xmu_simplex_corner}},
  \code{\link{xmu_start_value_list}}
}
\concept{xmu internal not for end user}
