% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_builders.r
\name{umxEFA}
\alias{umxEFA}
\alias{umxFactanal}
\title{umxEFA}
\usage{
umxEFA(x = NULL, factors = NULL, data = NULL, covmat = NULL,
  n.obs = NULL, scores = c("none", "ML", "WeightedML", "Regression"),
  minManifests = NA, rotation = c("varimax", "promax", "none"),
  name = "efa", digits = 2, report = c("markdown", "html"))
}
\arguments{
\item{x}{Either 1: data, 2: A formula (not implemented yet), 3: A vector of variable names, or 4: A name for the model.}

\item{factors}{Either number of factors to request or a vector of factor names.}

\item{data}{A dataframe of manifest columns you are modeling}

\item{covmat}{Covariance matrix of data you are modeling (not implemented)}

\item{n.obs}{Number of observations in covmat (if provided, default = NA)}

\item{scores}{Type of scores to produce, if any. The default is none, "Regression" gives Thompson's scores. Other options are 'ML', 'WeightedML', Partial matching allows these names to be abbreviated.}

\item{minManifests}{The least number of variables required to return a score for a participant (Default = NA).}

\item{rotation}{A rotation to perform on the loadings (default  = "varimax" (orthogonal))}

\item{name}{A name for your model}

\item{digits}{rounding (default = 2)}

\item{report}{Report as markdown to the console, or open a table in browser ("html")}
}
\value{
- EFA \code{\link{mxModel}}
}
\description{
Perform full-information maximum-likelihood factor analysis on a data matrix.
as in \code{\link{factanal}}, you need only specify the number of factors and offer up
some manifest data, e.g:
                                                             
\code{umxEFA(factors = 2, data = mtcars)}
}
\details{
Equivalently, you can also give a list of factor names:

\code{umxEFA(factors = c("g", "v"), data = mtcars)}

The factor model is implemented as a structural equation model, e.g.

\figure{umxEFA.png}

You can request \code{scores} from the model. Unlike factanal, these can cope with missing data.


In an EFA, all items may load on all factors.
For identification we need m^2 degrees of freedom. We get m * (m+1)/2 from fixing factor variances to 1 and covariances to 0.
We get another m(m-1)/2 degrees of freedom by fixing the upper-right hand corner of the factor loadings
component of the A matrix. The manifest variances are also lbounded at 0.

EFA reports standardized loadings: to do this, we scale the data.

Bear in mind that factor scores are indeterminate and can be rotated.

This is very much early days.
}
\examples{
myVars <- c("mpg", "disp", "hp", "wt", "qsec")
m1 = umxEFA(mtcars[, myVars], factors =   2, rotation = "promax")
loadings(m1)
m2 = factanal(~ mpg + disp + hp + wt + qsec, factors = 2, rotation = "promax", data = mtcars)
loadings(m2)
\dontrun{
plot(m2)
m1 = umxEFA(myVars, factors = 2, data = mtcars, rotation = "promax")
m1 = umxEFA(name = "named", factors = "g", data = mtcars[, myVars])
m1 = umxEFA(name = "by_number", factors = 2, rotation = "promax", data = mtcars[, myVars])
x = umxEFA(name = "score", factors = "g", data = mtcars[, myVars], scores= "Regression")
}
}
\references{
- \url{http://github.com/tbates/umx}
}
\seealso{
- \code{\link{factanal}}, \code{\link{mxFactorScores}}

Other Super-easy helpers: \code{\link{umxTwoStage}},
  \code{\link{umx}}
}
