% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxSummaryCP}
\alias{umxSummaryCP}
\alias{umxSummary.MxModel.CP}
\title{umxSummaryCP}
\usage{
umxSummaryCP(model, digits = 2, file = umx_set_auto_plot(silent = TRUE),
  returnStd = FALSE, extended = FALSE, showRg = TRUE, comparison = NULL,
  std = TRUE, CIs = FALSE, ...)
}
\arguments{
\item{model}{A fitted \code{\link{umxCP}} model to summarize}

\item{digits}{round to how many digits (default = 2)}

\item{file}{The name of the dot file to write: NA = none; "name" = use the name of the model}

\item{returnStd}{Whether to return the standardized form of the model (default = FALSE)}

\item{extended}{how much to report (FALSE)}

\item{showRg}{Whether to show the genetic correlations (FALSE) (Not implemented!)}

\item{comparison}{Whether to run mxCompare on a comparison model (NULL)}

\item{std}{Whether to show the standardized model (TRUE) (ignored: used extended = TRUE to get unstandardized)}

\item{CIs}{Confidence intervals (F)}

\item{...}{Optional additional parameters}
}
\value{
- optional \code{\link{mxModel}}
}
\description{
Summarise a Commmon Pathway model, as returned by \code{\link{umxCP}}
}
\examples{
require(umx)
data(twinData) 
zygList = c("MZFF", "MZMM", "DZFF", "DZMM", "DZOS")
twinData$ZYG = factor(twinData$zyg, levels = 1:5, labels = zygList)
twinData$wt1 = twinData$wt1/10 # help CSOLNP by putting wt on a similar scale to ht
twinData$wt2 = twinData$wt2/10 # help CSOLNP by putting wt on a similar scale to ht
selDVs = c("ht", "wt")
mzData <- subset(twinData, ZYG == "MZFF", umx_paste_names(selDVs, "", 1:2))
dzData <- subset(twinData, ZYG == "DZFF", umx_paste_names(selDVs, "", 1:2))
m1 = umxCP(selDVs = selDVs, dzData = dzData, mzData = mzData, suffix = "")
umxSummaryCP(m1, file = NA) # suppress plot creation with file
umxSummary(m1, file = NA) # generic summary is the same
stdFit = umxSummaryCP(m1, digits = 2, file = NA, returnStd = TRUE, 
		extended = FALSE, showRg = TRUE, std = TRUE, CIs = TRUE);
umxSummaryCP(m1, ext = TRUE, file = "name")
umxSummaryCP(m1, file = "Figure 3", std = TRUE)
}
\references{
- \url{http://www.github.com/tbates/umx}, \url{http://tbates.github.io}
}
\seealso{
- \code{\link{umxCP}()}, \code{\link{plot}()}, \code{\link{umxSummary}()} work for IP, CP, GxE, SAT, and ACE models.

Other Twin Modeling Functions: \code{\link{plot.MxModel}},
  \code{\link{umxACESexLim}}, \code{\link{umxACEcov}},
  \code{\link{umxACE}}, \code{\link{umxCF_SexLim}},
  \code{\link{umxCP}}, \code{\link{umxGxE_window}},
  \code{\link{umxGxE}}, \code{\link{umxIP}},
  \code{\link{umxPlotACEcov}}, \code{\link{umxPlotCP}},
  \code{\link{umxPlotGxE}}, \code{\link{umxPlotIP}},
  \code{\link{umxSummaryACEcov}},
  \code{\link{umxSummaryACE}}, \code{\link{umxSummaryGxE}},
  \code{\link{umxSummaryIP}},
  \code{\link{umx_make_TwinData}}, \code{\link{umx}}
}
