% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_make_bin_cont_pair_data}
\alias{umx_make_bin_cont_pair_data}
\title{umx_make_bin_cont_pair_data}
\usage{
umx_make_bin_cont_pair_data(data, vars = NULL, suffixes = NULL)
}
\arguments{
\item{data}{A \code{\link{data.frame}} to convert}

\item{vars}{The variables to process}

\item{suffixes}{Suffixes if the data are family (wide, more than one persona on a row)}
}
\value{
- copy of the dataframe with new binary variables and censoring
}
\description{
Takes a dataframe of left-censored variables (vars with a floor effect) and does two things to it:
1. It creates new binary (1/0) copies of each column (with the suffix "bin"). These contain 0 where
   the variable is below the minimum and NA otherwise.
2. In each existing variable, it sets all instances of min for that var to NA
}
\examples{
df = umx_make_bin_cont_pair_data(mtcars, vars = c("mpg"))
str(df)
df[order(df$mpg), c(1,12)]
# Introduce a floor effect
tmp = mtcars; tmp$mpg[tmp$mpg<=15]=15
tmp$mpg_T1 = tmp$mpg_T2 = tmp$mpg
df = umx_make_bin_cont_pair_data(tmp, vars = c("mpg"), suffixes = c("_T1", "_T2"))
df[order(df$mpg), 12:15]
}
\references{
- \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}, \url{http://openmx.ssri.psu.edu}
}
\seealso{
Other Data Functions: \code{\link{umxCovData}},
  \code{\link{umxFactor}}, \code{\link{umxHetCor}},
  \code{\link{umxPadAndPruneForDefVars}},
  \code{\link{umx_as_numeric}},
  \code{\link{umx_cont_2_quantiles}},
  \code{\link{umx_cov2raw}}, \code{\link{umx_lower2full}},
  \code{\link{umx_make_MR_data}},
  \code{\link{umx_make_fake_data}},
  \code{\link{umx_merge_CIs}},
  \code{\link{umx_read_lower}}, \code{\link{umx_reorder}},
  \code{\link{umx_residualize}}, \code{\link{umx_round}},
  \code{\link{umx_scale_wide_twin_data}},
  \code{\link{umx_scale}}, \code{\link{umx_swap_a_block}},
  \code{\link{umx}}
}

