% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_explode_twin_names}
\alias{umx_explode_twin_names}
\title{umx_explode_twin_names}
\usage{
umx_explode_twin_names(df, sep = "_T")
}
\arguments{
\item{df}{vector of names or data.frame containing the data}

\item{sep}{text constant separating name from numeric 1:2 twin index}
}
\value{
- list(varnames = c("Dep"), sep = "_T", twinIndexes = c(1,2))
}
\description{
Break names like Dep_T1 into a list of base names, a seperator, and a 
vector of twin indexes. e.g. c("Dep_T1", "Dep_T2") 
-> list(varnames = c("Dep"), sep = "_T", twinIndexes = c(1,2))
}
\examples{
require(umx)
data("twinData")
umx_explode_twin_names(twinData, sep = "")
# Single-character single variable test case
x = round(10 * rnorm(1000, mean = -.2))
y = round(5 * rnorm(1000))
x[x < 0] = 0; y[y < 0] = 0
umx_explode_twin_names(data.frame(x_T1 = x, x_T2 = y), sep = "_T")
umx_explode_twin_names(data.frame(x_T11 = x, x_T22 = y), sep = "_T")
}
\seealso{
Other String Functions: \code{\link{umx_explode}},
  \code{\link{umx_rot}}, \code{\link{umx_trim}}
}

