% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxSummaryIP}
\alias{umxSummary.MxModel.IP}
\alias{umxSummaryIP}
\title{umxSummaryIP}
\usage{
umxSummaryIP(model, digits = 2, dotFilename = c(NA, "name",
  "make_up_a_file_name"), returnStd = FALSE, showStd = FALSE,
  showRg = TRUE, comparison = NULL, CIs = FALSE, ...)
}
\arguments{
\item{model}{A fitted \code{\link{umxIP}} model to summarize}

\item{digits}{rounding (default = 2)}

\item{dotFilename}{The name of the dot file to write. Defaults to name of the model. NA = no plot}

\item{returnStd}{Whether to return the standardized form of the model (default = F)}

\item{showStd}{= Whether to show the standardized model (TRUE)}

\item{showRg}{= whether to show the genetic correlations (F)}

\item{comparison}{Whether to run mxCompare on a comparison model (NULL)}

\item{CIs}{Confidence intervals (F)}

\item{...}{Optional additional parameters}
}
\value{
- optional \code{\link{mxModel}}
}
\description{
Summarise a Independent Pathway model, as returned by \code{\link{umxIP}}
}
\examples{
require(OpenMx)
data(twinData)
labList = c("MZFF", "MZMM", "DZFF", "DZMM", "DZOS")
twinData$ZYG = factor(twinData$zyg, levels = 1:5, labels = labList)
selDVs = c("ht1", "wt1", "ht2", "wt2")
mzData <- subset(twinData, ZYG == "MZFF")
dzData <- subset(twinData, ZYG == "DZFF")
m1 = umxIP(selDVs = selDVs, dzData = dzData, mzData = mzData)
m1 = umxRun(m1)
umxSummaryIP(m1, dotFilename = NA) # suppress graphing with NA for CRAN
\dontrun{
umxSummaryIP(m1, digits = 2, dotFilename = "Figure3", showRg = FALSE, CIs = TRUE);
}
}
\references{
- \url{http://github.com/tbates/umx}, \url{http://tbates.github.io}
}
\seealso{
- \code{\link{umxIP}()}, \code{\link{plot}()}, \code{\link{umxSummary}()} work for IP, CP, GxE, SAT, and ACE models.
}

