% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_show}
\alias{umx_show}
\title{umx_show}
\usage{
umx_show(model, what = c("values", "free", "labels", "nonzero_or_free"),
  matrices = c("S", "A"), digits = 2)
}
\arguments{
\item{model}{an \code{\link{mxModel}} to show data from}

\item{what}{legal options are "values" (default), "free", or "labels")}

\item{matrices}{to show  (default is c("S", "A"))}

\item{digits}{precision to report, defaults to rounding to 2 decimal places}
}
\value{
- \code{\link{mxModel}}
}
\description{
Show matrix contents. The user can select  values, free, and/or labels, and which matrices to display
}
\examples{
require(OpenMx)
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
m1 <- mxModel("One Factor", type = "RAM",
	manifestVars = manifests, latentVars = latents,
	mxPath(from = latents, to = manifests),
	mxPath(from = manifests, arrows = 2),
	mxPath(from = latents, arrows = 2, free = FALSE, values = 1.0),
	mxData(cov(demoOneFactor), type = "cov", numObs = 500)
)
m1 = umxRun(m1, setLabels = TRUE, setValues = TRUE)
umx_show(m1)
umx_show(m1, digits = 3)
umx_show(m1, matrices = "S")
umx_show(m1, what = "free")
umx_show(m1, what = "labels")
umx_show(m1, what = "free", "A")
}
\references{
- \url{http://tbates.github.io}, \url{https://github.com/tbates/umx}, \url{http://openmx.psyc.virginia.edu}
}
\seealso{
- \code{\link{umxLabel}}, \code{\link{umxRun}}, \code{\link{umxStart}}

Other Reporting Functions: \code{\link{umxStandardizeACE}};
  \code{\link{umx_APA_CI}}; \code{\link{umx_APA_pval}};
  \code{\link{umx_aggregate}}; \code{\link{umx_print}};
  \code{\link{umx_time}}; \code{\link{umx}},
  \code{\link{umx-package}}
}

