% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_print}
\alias{umx_print}
\title{umx_print}
\usage{
umx_print(x, digits = getOption("digits"), quote = FALSE, na.print = "",
  zero.print = "0", justify = "none", file = c(NA, "tmp.html"),
  suppress = NULL, ...)
}
\arguments{
\item{x}{A data.frame to print}

\item{digits}{The number of decimal places to print (defaults to getOption("digits")}

\item{quote}{Parameter passed to print (defaults to FALSE)}

\item{na.print}{String to replace NA with (default to blank "")}

\item{zero.print}{String to replace 0.000 with  (defaults to "0")}

\item{justify}{Parameter passed to print (defaults to "none")}

\item{file}{whether to write to a file (defaults to NA (no file). Use "tmp.html" to open as tables in browser.}

\item{suppress}{minimum numeric value to print (default =  NULL, print all values, no matter how small)}

\item{...}{Optional parameters for print}
}
\description{
A helper to aid the interpretability of printed tables from OpenMx (and elsewhere).
Its most useful characteristic is allowing you to change how NA and zero appear.
By default, Zeros have the decimals suppressed, and NAs are suppressed altogether.
}
\examples{
umx_print(mtcars[1:10,], digits = 2, zero.print = ".", justify = "left")
\dontrun{
umx_print(model)
umx_print(mtcars[1:10,], file = "Rout.html")
}
}
\seealso{
- \code{\link{print}}

Other Miscellaneous Functions: \code{\link{umxEval}};
  \code{\link{umxJiggle}}; \code{\link{umx_APA_pval}};
  \code{\link{umx_add_variances}}; \code{\link{umx_apply}};
  \code{\link{umx_check_model}};
  \code{\link{umx_check_multi_core}};
  \code{\link{umx_checkpoint}},
  \code{\link{umx_set_checkpoint}};
  \code{\link{umx_check}};
  \code{\link{umx_default_option}};
  \code{\link{umx_explode}};
  \code{\link{umx_get_CI_as_APA_string}};
  \code{\link{umx_get_bracket_addresses}};
  \code{\link{umx_get_checkpoint}};
  \code{\link{umx_get_cores}};
  \code{\link{umx_get_optimizer}};
  \code{\link{umx_has_CIs}};
  \code{\link{umx_has_been_run}};
  \code{\link{umx_has_means}};
  \code{\link{umx_has_square_brackets}};
  \code{\link{umx_is_MxMatrix}};
  \code{\link{umx_is_MxModel}}; \code{\link{umx_is_RAM}};
  \code{\link{umx_is_cov}};
  \code{\link{umx_is_endogenous}};
  \code{\link{umx_is_exogenous}};
  \code{\link{umx_is_ordered}}; \code{\link{umx_msg}};
  \code{\link{umx_names}}; \code{\link{umx_object_as_str}};
  \code{\link{umx_paste_names}}; \code{\link{umx_rename}};
  \code{\link{umx_reorder}}; \code{\link{umx_rot}};
  \code{\link{umx_set_cores}};
  \code{\link{umx_set_optimizer}};
  \code{\link{umx_string_to_algebra}};
  \code{\link{umx_trim}}; \code{\link{umx}},
  \code{\link{umx-package}}

Other Reporting Functions: \code{\link{umxStandardizeACE}};
  \code{\link{umx_APA_CI}}; \code{\link{umx_APA_pval}};
  \code{\link{umx_aggregate}}; \code{\link{umx_show}};
  \code{\link{umx_time}}; \code{\link{umx}},
  \code{\link{umx-package}}
}

