% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stop-search-location.R, R/ukpolice-deprecated.R
\name{ukc_stop_search_loc}
\alias{ukc_stop_search_loc}
\alias{ukc_stop_search_coord}
\alias{ukc_stop_search_poly}
\alias{ukc_stop_search_location}
\title{Stop and search}
\usage{
ukc_stop_search_loc(location, date = NULL, ...)

ukc_stop_search_coord(lat, lng, date = NULL, ...)

ukc_stop_search_poly(poly_df, date = NULL, ...)

ukc_stop_search_location(lat, lng, location, date = NULL)
}
\arguments{
\item{location}{If specified, \code{lat} and \code{lng} are ignored. Location IDs are
available through other methods including \code{\link[=ukc_street_crime]{ukc_street_crime()}}.}

\item{date}{The year and month in "YYYY-MM" form. If \code{NULL}, latest
available month will be returned. Also accepts dates in formats that can be
coerced to \code{Date} class with \code{as.Date()}.}

\item{...}{further arguments passed to \code{\link[httr:GET]{httr::GET}}.}

\item{lat}{Latitude. Accepts a single value or a vector of values to create
a custom polygon.}

\item{lng}{Longitude. Accepts a single value or a vector of values to create
a custom polygon.}

\item{poly_df}{a dataframe containing the lat/lng pairs which define
the boundary of the custom area, or a \code{\link[sf:sf]{sf}} or
\code{\link[sp:SpatialPointsDataFrame]{SpatialPointsDataFrame}} object.
The first and last coordinates need not be the same — they will be joined
by a straight line once the request is made. If a dataframe, the lat/lng
must be the first two columns, or named \code{"lat"} and \code{"lng"}.}
}
\value{
A \code{tibble} with details of stop and searches outcomes.
}
\description{
Returns details on stops and searches at a given location. The stop and
searches returned in the API, like the crimes, are only an approximation
of where the actual stop and searches occurred, they are not the exact
locations.
}
\details{
Functions accept one of \code{lat} and \code{lng} pairs, \code{location} IDs or
a dataframe containing lat/lng pairs defining the boundary of a custom area.

If specified, \code{lat} and \code{lng} must be the same length. If only one
set of coordinates are given, all recorded stop and searches within a one
mile radius are returned. If multiple pairs, all recorded stop and searches
within a custom drawn polygon will be returned.
}
\examples{
\dontrun{

ukc_stop_search2 <- ukc_stop_search_coord(
  lat = c(52.268, 53.194, 52.130),
  lng = c(0.543, 0.238, 0.478)
)


poly_df_4 <- data.frame(
  lat = c(52.268, 52.794, 52.130, 52.000),
  long = c(0.543, 0.238, 0.478, 0.400)
)

ukc_data_poly_4 <- ukc_stop_search_poly(poly_df = poly_df_4)
}

}
\seealso{
\code{\link[=ukc_stop_search_force]{ukc_stop_search_force()}}

\code{\link[=ukc_stop_search_no_location]{ukc_stop_search_no_location()}}
}
