% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ukbabynames.R
\docType{data}
\name{ukbabynames}
\alias{ukbabynames}
\title{UK baby names}
\format{
A data frame with 550,587 observations on 6 variables.
\describe{
\item{year}{A year (1974-2020).}
\item{sex}{Sex, \code{M} for male and \code{F} for female.}
\item{name}{A name.}
\item{n}{Count of name within year and sex.}
\item{rank}{Rank of name within year and sex.}
\item{nation}{Nation of data source.}
}
}
\source{
Office of National Statistics. 2021. \href{https://www.ons.gov.uk/peoplepopulationandcommunity/birthsdeathsandmarriages/livebirths/datasets/babynamesenglandandwalesbabynamesstatisticsgirls}{Baby Names Statistics Girls}.
Office of National Statistics. 2021. \href{https://www.ons.gov.uk/peoplepopulationandcommunity/birthsdeathsandmarriages/livebirths/datasets/babynamesenglandandwalesbabynamesstatisticsboys}{Baby Names Statistics Boys}.
Northern Ireland Statistics and Research Agency. 2021. \href{https://www.nisra.gov.uk/publications/baby-names-2018}{Baby Names Statistics Boys and Girls}.
National Records of Scotland. 2021. \href{https://www.nrscotland.gov.uk/statistics-and-data/statistics/statistics-by-theme/vital-events/names/babies-first-names/babies-first-names-2020}{Baby Names Statistics Boys and Girls}.
}
\usage{
ukbabynames
}
\description{
Full baby name data 1974-2020 for the United Kingdom from all nations. Contains
data from England and Wales (\code{ewbabynames}), Scotland (\code{scotbabynames}), and
Northern Ireland (\code{nibabynames}).
}
\examples{
library(ggplot2)
library(dplyr)

ukbabynames \%>\%
  filter(name == "Jack") \%>\%
  ggplot(aes(x = year, y = n, color = nation)) +
  geom_line() +
  labs(
     title = "Popularity of the name `Jack` in the UK",
     subtitle = "by Nation", 
     x = "Year", y = "Number of babies",  color = NULL
     )
}
\keyword{datasets}
