% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportToHTML.R
\name{exportToHTML}
\alias{exportToHTML}
\title{Exporting tables to HTML}
\usage{
exportToHTML(
  input,
  output = ufs::opts$get("tableOutput"),
  tableOutputCSS = ufs::opts$get("tableOutputCSS")
)
}
\arguments{
\item{input}{Either a \code{data.frame}, \code{table}, or \code{matrix},
or a list with three elements: \code{pre}, \code{input}, and \code{post}.
The \code{pre} and \code{post} are simply prepended and postpended to
the HTML generated based on the \code{input$input} element.}

\item{output}{The output: a character vector with one or more
of "\code{console}" (the raw concatenated input, without conversion
to HTML), "\code{viewer}", which uses the RStudio viewer if available,
and one or more filenames in existing directories.}

\item{tableOutputCSS}{The CSS to use for the HTML table.}
}
\value{
Invisibly, the (potentially concatenated) \code{input} as character
vector.
}
\description{
This function exports data frames or matrices to
HTML, sending output to one or more of the console,
viewer, and one or more files.
}
\examples{
exportToHTML(mtcars[1:5, 1:5]);
}
