% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knitAndSave.R
\name{knitAndSave}
\alias{knitAndSave}
\title{knitAndSave}
\usage{
knitAndSave(plotToDraw, figCaption, file = NULL, path = NULL,
  figWidth = 8, figHeight = 8,
  catPlot = getOption("ufs.knitAndSave.catPlot", FALSE), ...)
}
\arguments{
\item{plotToDraw}{The plot to knit using \code{\link[=knitFig]{knitFig()}} and save using \code{\link[=ggSave]{ggSave()}}.}

\item{figCaption}{The caption of the plot (used as filename if no filename is specified).}

\item{file, path}{The filename to use when saving the plot, or the path where to save the
file if no filename is provided (if \code{path} is also omitted, \code{getWd()} is used).}

\item{figWidth, figHeight}{The plot dimensions, by default specified in inches (but 'units' can
be set which is then passed on to \code{\link[=ggSave]{ggSave()}}.}

\item{catPlot}{Whether to use \code{\link[=cat]{cat()}} to print the knitr fragment.}

\item{...}{Additional arguments are passed on to \code{\link[=ggSave]{ggSave()}}. Note that file (and ...) are
vectorized (see the \code{\link[=ggSave]{ggSave()}} manual page).}
}
\value{
The \code{\link[=knitFig]{knitFig()}} result, visibly.
}
\description{
knitAndSave
}
\examples{
\donttest{plot <- ggBoxplot(mtcars, 'mpg');
knitAndSave(plot, figCaption="a boxplot", file=tempfile(fileext=".png"));}
}
