% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch-ucirepo.R
\name{fetch_ucirepo}
\alias{fetch_ucirepo}
\title{Fetch UCI ML Repository Dataset}
\usage{
fetch_ucirepo(name, id)
}
\arguments{
\item{name}{Character. Dataset name, or substring of name.}

\item{id}{Integer. Dataset ID for UCI ML Repository.}
}
\value{
A list containing dataset metadata, dataframes, and variable info in its properties.
\itemize{
\item \strong{data}: Contains dataset matrices as pandas dataframes
\itemize{
\item \strong{ids}: Dataframe of ID columns
\item \strong{features}: Dataframe of feature columns
\item \strong{targets}: Dataframe of target columns
\item \strong{original}: Dataframe consisting of all IDs, features, and targets
\item \strong{headers}: List of all variable names/headers
}
\item \strong{metadata}: Contains metadata information about the dataset.
\itemize{
\item \strong{uci_id}: Unique dataset identifier for UCI repository
\item \strong{name}: Name of dataset on UCI repository
\item \strong{repository_url}: Link to dataset webpage on the UCI repository
\item \strong{data_url}: Link to raw data file
\item \strong{abstract}: Short description of dataset
\item \strong{area}: Subject area e.g. life science, business
\item \strong{tasks}: Associated machine learning tasks e.g. classification, regression
\item \strong{characteristics}: Dataset types e.g. multivariate, sequential
\item \strong{num_instances}: Number of rows or samples
\item \strong{num_features}: Number of feature columns
\item \strong{feature_types}: Data types of features
\item \strong{target_col}: Name of target column(s)
\item \strong{index_col}: Name of index column(s)
\item \strong{has_missing_values}: Whether the dataset contains missing values
\item \strong{missing_values_symbol}: Indicates what symbol represents the missing entries (if the dataset has missing values)
\item \strong{year_of_dataset_creation}: Year that data set was created
\item \strong{dataset_doi}: DOI registered for dataset that links to UCI repo dataset page
\item \strong{creators}: List of dataset creator names
\item \strong{intro_paper}: Information about dataset's published introductory paper
\item \strong{external_url}: URL to external dataset page. This field will only exist for linked datasets i.e. not hosted by UCI
\item \strong{additional_info}: Descriptive free text about dataset
\itemize{
\item \strong{summary}: General summary
\item \strong{purpose}: For what purpose was the dataset created?
\item \strong{funded_by}: Who funded the creation of the dataset?
\item \strong{instances_represent}: What do the instances in this dataset represent?
\item \strong{recommended_data_splits}: Are there recommended data splits?
\item \strong{sensitive_data}: Does the dataset contain data that might be considered sensitive in any way?
\item \strong{preprocessing_description}: Was there any data preprocessing performed?
\item \strong{variable_info}: Additional free text description for variables
\item \strong{citation}: Citation Requests/Acknowledgements
}
}
\item \strong{variables}: Contains variable details presented in a tabular/dataframe format
\itemize{
\item \strong{name}: Variable name
\item \strong{role}: Whether the variable is an ID, feature, or target
\item \strong{type}: Data type e.g. categorical, integer, continuous
\item \strong{demographic}: Indicates whether the variable represents demographic data
\item \strong{description}: Short description of variable
\item \strong{units}: Variable units for non-categorical data
\item \strong{missing_values}: Whether there are missing values in the variable's column
}
}
}
\description{
Loads a dataset from the UCI ML Repository, including the dataframes and
metadata information.
}
\details{
Only provide name or id, not both.
}
\examples{
# Access Data by Name
iris_dl <- fetch_ucirepo(name = "iris")

# Access original data
iris_uci <- iris_dl$data$original

# Access features and targets
iris_features <- iris_dl$data$features
iris_targets <- iris_dl$data$targets

# Access Data by ID
iris_dl <- fetch_ucirepo(id = 53)

}
