% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{system_glp_scenario}
\alias{system_glp_scenario}
\title{Design GLP Study For a Scenario}
\usage{
system_glp_scenario(
  cfg,
  output_Conc = NULL,
  output_AUC = NULL,
  timescale = NULL,
  units_Conc = "",
  units_AUC = "",
  study_scenario = "Tox Study",
  human_sim_times = NULL,
  study_name = "default",
  human_parameters = NULL,
  human_bolus = NULL,
  human_ndose = 1,
  human_dose_interval = 1,
  human_Cmin = NULL,
  human_AUC = NULL,
  human_sample_interval = NULL,
  human_sim_doses = NULL,
  human_sim_samples = NULL,
  tox_species = "Tox",
  tox_sim_times = NULL,
  tox_parameters = NULL,
  tox_bolus = NULL,
  tox_ndose = 1,
  tox_dose_interval = 1,
  tox_Cmax_multiple = 10,
  tox_AUC_multiple = 10,
  tox_sample_interval = NULL,
  tox_sim_doses = NULL,
  tox_sim_samples = NULL,
  annotate_plots = TRUE
)
}
\arguments{
\item{cfg}{ubiquity system object}

\item{output_Conc}{model output specified with \code{<O>} containing the concentration associated with drug exposure.}

\item{output_AUC}{model output specified with \code{<O>} containing the cumulative exposure}

\item{timescale}{system timescale specified with \code{<TS>} used for AUC comparisons and plotting}

\item{units_Conc}{units of concentration (\code{''})}

\item{units_AUC}{units of AUC (\code{''})}

\item{study_scenario}{string containing a descriptive name for the tox study}

\item{human_sim_times}{user-specified simulation output times for humans (same timescale as the system)}

\item{study_name}{name of the study to append the scenario to set with \code{'system_glp_init()'} (\code{'default'}):
When a report is initialized using \code{\link{system_report_init}} the report name is 'default' unless otherwise specified. To disable reporting set this to  \code{NULL}, and to use a different report specify the name here.}

\item{human_parameters}{list containing the human parameters}

\item{human_bolus}{string containing the dosing state for human doses (specified with \code{<B:?>})}

\item{human_ndose}{number of human doses to simulate}

\item{human_dose_interval}{dosing interval in humans (time units specified with \code{<B:?>})}

\item{human_Cmin}{target Cmin in humans (corresponding to output_Conc above)}

\item{human_AUC}{target AUC  in humans (corresponding to output_AUC  above)}

\item{human_sample_interval}{time interval in units specified by timescale above to evaluate the trough concentration and AUC (e.g c(1.99, 4.001) would consider the interval between 2 and 4)}

\item{human_sim_doses}{optional list of doses into \code{human_bolus} to simulate (see Details below)}

\item{human_sim_samples}{optional list of sample times in units specified by timescale above to label on plots of simulated doses (the default \code{NULL} will disable labels)}

\item{tox_species}{optional name of the tox species (\code{"Tox"})}

\item{tox_sim_times}{user-specified simulation output times for the tox species (same timescale as the system)}

\item{tox_parameters}{list containing the parameters for the tox species}

\item{tox_bolus}{string containing the dosing state for tox species doses (specified with \code{<B:?>})}

\item{tox_ndose}{number of tox doses to simulate}

\item{tox_dose_interval}{dosing interval in the tox species (time units specified with \code{<B:?>})}

\item{tox_Cmax_multiple}{for each target (Cmin and AUC) the dose in the tox species will be found to cover this multiple over the projected Cmax in humans (10)}

\item{tox_AUC_multiple}{for each target (Cmin and AUC) the dose in the tox species will be found to cover this multiple over the projected AUC in humans (10)}

\item{tox_sample_interval}{interval to consider the AUC and Cmax for comparing the human prediction to the tox multiple}

\item{tox_sim_doses}{optional list of doses into \code{tox_bolus} to simulate (see Details below)}

\item{tox_sim_samples}{optional list of sample times in units specified by timescale above to label on plots of simulated doses (the default \code{NULL} will disable labels)}

\item{annotate_plots}{Boolean switch to indicate if \code{human_sim_samples} and \code{tox_sim_samples} should be labeled on  their respective plots (\code{TRUE})}
}
\value{
cfg ubiquity system object with the scenario added if successful
}
\description{
Identifies the top dose required in a GLP tox study in order to match human metrics (Cmax and AUCs) within a specified multiplier.
 
For a given set of human parameters the human doses required to hit the target Cmin and AUC (both or one) will be identified. The Cmax and AUC associated with the largest of those doses will be determined and the corresponding doses for a tox species (and provided parameters) will be determined for specific tox multipliers. 
 
Optionally, simulations can be be run by specifying doses for either/or the human or tox species. Sample times can also be specified to generate annotated figures and tables to be given to analysts to facilitate assay design. 

The system file requires the following components:

 - Output for the drug concentration
 - Output for the cumulative AUC
 - Bolus dosing defined in a specific compartment
 - Timescale specified for the system timescale  (e.g. if the timescale is hours then you need \code{<TS> hours = 1.0})
}
\details{
Both \code{human_sim_doses} and \code{tox_sim_doses} are lists with names
 corresponding to the label of the dose. Each element has an AMT and TIME
 element which corresponds to the dosing times and amounts in the units 
 specified with \code{<B:?>} in the system file.

 For example if you wanted to simulate four weekly doses of 20 mg to a 70 kg 
 person and the units of bolus doses were days and mg/kg for the times and 
 amounts you would do the following:

\preformatted{
 human_sim_doses = list()
 human_sim_doses[["20 mg QW"]]$TIME = c(     0,      7,     14,     21)
 human_sim_doses[["20 mg QW"]]$AMT  = c(0.2857, 0.2857, 0.2857, 0.2857)
}
}
