% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{route_map}
\alias{route_map}
\title{Create a route map for a trip}
\usage{
route_map(start_latitude = NULL, start_longitude = NULL,
  end_latitude = NULL, end_longitude = NULL, start_address = NULL,
  end_address = NULL, key = "", zoom = 14)
}
\arguments{
\item{start_latitude}{Initial latitude.}

\item{start_longitude}{Initial longitude.}

\item{end_latitude}{Final latitude.}

\item{end_longitude}{Final longitude.}

\item{start_address}{Initial address.}

\item{end_address}{Final address.}

\item{key}{Google Maps API key (optional).}

\item{zoom}{Map zoom, an integer from 3 (continent) to 21 (building).}
}
\value{
A \code{ggplot2} graphics object.
}
\description{
A map, centered at the mean of the start and end locations, is accessed via
\code{\link[ggmap]{get_map}} and a suitable driving route between these
points is constructed using \code{\link[googleway]{google_directions}} then
added to the map.
}
\examples{
\dontrun{
route_map(start_address = "37 Beach Road, Mouille Point, Cape Town",
          end_address = "100 St Georges Mall, Cape Town City Centre, Cape Town")
}
}

