% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fa_treepos.R
\name{treepos_GWS}
\alias{treepos_GWS}
\title{Find potential tree positions using a canopy height model}
\usage{
treepos_GWS(
  chm = NULL,
  minTreeAlt = 10,
  minTreeAltParam = "chmQ20",
  minCrownArea = 3,
  maxCrownArea = 150,
  join = 1,
  thresh = 0.1,
  split = TRUE,
  cores = parallel::detectCores(),
  giLinks = NULL
)
}
\arguments{
\item{chm}{raster* canopy height model}

\item{minTreeAlt}{numeric. minimum height of trees to be integrated in the analysis}

\item{minTreeAltParam}{character. code for the percentile that is used as tree height treshold. It is build using the key letters \code{chmQ} and adding the percentile i.e. "10". Default is \code{chmQ20}}

\item{minCrownArea}{numeric. minimum area in square meter (if you use projected data) of the projected tree crowns}

\item{maxCrownArea}{numeric. maximum area in square meter (if you use projected data) of the projected tree crowns}

\item{join}{numeric. Join Segments based on Threshold Value, 0=no join, 1=treepos_GWS2saddle diff, 2=treepos_GWS2treepos diff. see also \href{http://www.saga-gis.org/saga_tool_doc/6.2.0/imagery_segmentation_0.html}{SAGA GIS Help}}

\item{thresh}{numeric. Specify a threshold value as minimum difference between neighboured segments in meter. see also \href{http://www.saga-gis.org/saga_tool_doc/6.2.0/imagery_segmentation_0.html}{SAGA GIS Help}}

\item{split}{split polygons default is TRUE}

\item{cores}{number of cores to be used}

\item{giLinks}{list. of GI tools cli paths}
}
\value{
raster* object

return raster* object
}
\description{
Find potential tree positions using a canopy height model by using an iterative watershed algorithm. Basically returns a  vector data sets with the tree crown geometries and a bunch of corresponding indices.
}
\examples{
\dontrun{

# required packages
require(uavRst)
require(link2GI)

# create and check the links to the GI software
giLinks<-uavRst::linkGI()
if (giLinks$saga$exist & giLinks$otb$exist & giLinks$grass$exist) {

# project folder
projRootDir<-tempdir()

# create subfolders please mind that the pathes are exported as global variables
paths<-link2GI::initProj(projRootDir = projRootDir,
                         projFolders = c("data/","data/ref/","output/","run/","las/"),
                         global = TRUE,
                         path_prefix = "path_")

 data(chm_seg)

# calculate treepos using uavRst generic approach
 tPos <- uavRst::treepos_GWS(chm = chm_seg[[1]],
                         minTreeAlt = 2,
                         maxCrownArea = 150,
                         join = 1,
                         thresh = 0.35,
                         split=TRUE,
                         cores=1,
                         giLinks = giLinks )
}
##+}

}
\author{
Chris Reudenbach
}
