% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rs_textures.R
\name{otbtex_gray}
\alias{otbtex_gray}
\title{Calculates Gray scale morphological operations for a given kernel size.}
\usage{
otbtex_gray(
  input = NULL,
  out = "morpho",
  ram = "8192",
  filter = "dilate",
  structype = "ball",
  xradius = 5,
  yradius = 5,
  channel = NULL,
  retRaster = FALSE,
  outDir = NULL,
  verbose = FALSE,
  otbLinks = NULL
)
}
\arguments{
\item{input}{of GeoTiff containing 1 ore more gray value bands}

\item{out}{the output mono band image containing the edge features}

\item{ram}{reserved memory in MB}

\item{filter}{the choice of the morphological operation (dilate/erode/opening/closing) (default value is dilate)}

\item{structype}{the choice of the structuring element type (ball/cross)}

\item{xradius}{x the ball structuring element X Radius (only if structype==ball)}

\item{yradius}{y the ball structuring element Y Radius (only if structype==ball)}

\item{channel}{sequence of bands to be processed}

\item{retRaster}{boolean if TRUE a raster stack is returned}

\item{outDir}{output Directory}

\item{verbose}{switch for system messages default is FALSE}

\item{otbLinks}{list. of GI tools cli pathes}
}
\value{
raster* object
}
\description{
Calculates Gray scale morphological operations for a given kernel size. return list of geotiffs containing thelocal statistics for each channel
}
\note{
the otb is used for filtering. please provide a GeoTiff file
}
\examples{
\dontrun{
# load libraries
require(uavRst)
require(link2GI)
require(listviewer)

setwd(tempdir())

# check if OTB exists
otbLinks <- link2GI::linkOTB()

if (otbLinks$exist) {
data("rgb")
raster::plotRGB(rgb)
fn<-file.path(tempdir(),"rgb.tif")
raster::writeRaster(rgb, 
                    filename=fn,
                    format="GTiff", 
                    overwrite=TRUE)
# get help
cmd<-link2GI::parseOTBFunction(algo = "GrayScaleMorphologicalOperation",gili=otbLinks)
listviewer::jsonedit(cmd$help)

r<-otbtex_gray(input="pacman.tif",retRaster = TRUE,otbLinks=otbLinks)

##- visualize all layers
raster::plot(r[[1]])
}
}
}
\author{
Chris Reudenbach
}
