% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wavealign.R
\name{wavealign}
\alias{wavealign}
\alias{wavealign,numeric,SpectralReference-method}
\alias{wavealign,Tile,SpectralReference-method}
\alias{wavealign,SpectralReference,Tile-method}
\alias{MosaicGetRef.wavealign}
\alias{TileRead.wavealign}
\title{Methods to resample the wavenumbers}
\usage{
wavealign(data.x, data.y)

\S4method{wavealign}{numeric,SpectralReference}(data.x, data.y)

\S4method{wavealign}{Tile,SpectralReference}(data.x, data.y)

\S4method{wavealign}{SpectralReference,Tile}(data.x, data.y)

MosaicGetRef.wavealign(data.x, data.y)

TileRead.wavealign(data.x, data.y)
}
\arguments{
\item{data.x}{An object of class \code{\link[=SpectralReference-class]{SpectralReference}} or \code{\link[=Tile-class]{Tile}}.}

\item{data.y}{An object of class \code{\link[=SpectralReference-class]{SpectralReference}} or \code{\link[=Tile-class]{Tile}}. It should be the other one.}
}
\value{
\itemize{
\item \bold{TileRead.wavealign} - An object of class \code{\link[=SpectralPack-class]{SpectralPack}}
\item \bold{MosaicGetRef.wavealign} - The \code{\link[=SpectralReference-class]{SpectralReference}} object passed as data.y, resampled to data.x.
}
}
\description{
It clips and resamples the wavenumbers of data.x and data.y to a common extent. Typically, it uses the wavenumbers of data.x to resample data.y and then the function clips the largest base on the narrowest.
}
\details{
There are two methods defined:
\itemize{
\item \bold{TileRead.wavealign} - This method should be the only one used by the user.
\item \bold{MosaicGetRef.wavealign} - This method is called internally by \code{\link{mosaic_sam}}. The method is different since it expect a numeric vector in data.x, which is taken from the wavenumbers slot of a \code{\link[=SpectralInfo-class]{SpectralInfo}} object. The implication is that, for mosaics, the \code{\link[=SpectralReference-class]{SpectralReference}} is always resampled according to the wavenumbers of the mosaics. It was programed this way, since mosaics are not loaded into the memory (R) until they are processed by mosaic_sam.
}
}
\examples{
x <- tile_read(base::system.file("extdata/tile.bsp", package = "uFTIR"))
x <- tile_base_corr(x)
x <- wavealign(x, primpke)
}
