% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgdal_polygonize.R
\name{rgdal_polygonize}
\alias{rgdal_polygonize}
\title{GDALPolygonize in R}
\usage{
rgdal_polygonize(raster, folder, layer, field, overwrite = TRUE)
}
\arguments{
\item{raster}{name/location of raster file to polygonize. Any driver included in GDAL should work.}

\item{folder}{name/location of the shape file to write. File extension should not be included.}

\item{layer}{name of the layer (.shp file) to write. Do not include de file extension.}

\item{field}{name of the field that will keep the raster values.}

\item{overwrite}{TRUE/FALSE to overwrite an existing file (folder).}
}
\value{
integer 0
}
\description{
The function calls the C GDALPolygonize routine (using C++). It does overwrite. It uses always 8 point connectedness. It writes on disc a file in "ESRI Shapefile" format.

I wrote a separate package with the function at first. However, I did not want to submit such a small package to CRAN to resolve the 'polygonize' problem. Therefor, I included the source code of that package in uFTIR at a later stage. If you are looking for a package to polygonize a raster file (similar to GDAL polygonize.py) you can use the GDALPolygonize package directly. You can find it in \href{https://github.com/fcorra/GDALPolygonize}{GitHub}.

That's also why this function is not exported for you to use it.
}
\examples{
NULL
}
