% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvVAR.R
\name{tvVAR}
\alias{tvVAR}
\alias{tvvar-class}
\alias{tvvar}
\title{Time-varying Vector Autoregressive Models}
\usage{
tvVAR(y, p = 1, z = NULL, bw = NULL, type = c("const", "none"),
  exogen = NULL, est = c("lc", "ll"), tkernel = c("Epa", "Gaussian"),
  singular.ok = TRUE)
}
\arguments{
\item{y}{A matrix with dimention obs x neq (obs = number of observations and
neq = number of equations)}

\item{p}{A scalar indicating the number of lags in the model}

\item{z}{A vector containing the smoothing variable.}

\item{bw}{An opcional scalar or vector of length the number of equations. It represents the bandwidth in
the estimation of trend coefficients. If NULL, it is selected by cross validation.}

\item{type}{A character 'const' if the model contains an intercept and 'none' otherwise.}

\item{exogen}{A matrix or data.frame with the exogenous variables (optional)}

\item{est}{The nonparametric estimation method, one of "lc" (default) for linear constant or "ll" for local linear.}

\item{tkernel}{The type of kernel used in the coefficients estimation method, one of Epanesnikov ("Epa") or "Gaussian".}

\item{singular.ok}{Logical. If FALSE, a singular model is an error.}
}
\value{
An object of class 'tvvar'
The object of class \code{tvvar} have the following components:
\item{tvcoef}{An array of dimension obs x neq (obs = number of observations,
neq = number of equations in the system) with the time-varying coefficients estimates.}
\item{fitted}{The fitted values.}
\item{residuals}{Estimation residuals.}
\item{x}{A list with the regressors data and the dependent variable.}
\item{y}{A matrix with the dependent variable data.}
\item{bw}{Bandwidth of mean estimation.}
\item{type}{Whether the model has a constant or not.}
\item{exogen}{A matrix or data.frame with other exogenous variables.}
\item{p}{Number of lags}
\item{neq}{Number of equations}
\item{obs}{Number of observations in estimation.}
\item{totobs}{Number of observations in the original set.}
\item{call}{Matched call.}
}
\description{
Fits a time-varying coefficients vector autorregressive model with p lags.
}
\examples{

## Inflation rate, unemployment rate and treasury bill interest rate for the US,
## as used by Primiceri (2005).
data(usmacro, package = "bvarsv")

model.VAR <- vars::VAR(usmacro, p = 6, type = "const")
model.tvVAR <- tvVAR(usmacro, p = 6, type = "const", bw = c(1.8, 20, 20))
plot(model.tvVAR)

}
\seealso{
\code{\link{CI}}, \code{\link{plot}}
}
