% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c_additional_functions.r
\name{tuwrap}
\alias{tuwrap}
\title{Wrapper of the models contained in the tuts package}
\usage{
tuwrap(y, ti.mu, ti.sd, n.sim, ...)
}
\arguments{
\item{y}{A vector of observations.}

\item{ti.mu}{A vector of estimates/observed timings of observations.}

\item{ti.sd}{A vector of standard deviations of timings.}

\item{n.sim}{A number of simulations.}

\item{...}{optional arguments: \cr
- CV: TRUE/FALSE cross-validation indicator, the default value is set to FALSE.
- n.chains: number of MCMC chains, the default number of chains is set to 2.\cr
- Thin: thinning factor, the default values is set to 4.\cr
- m: maximum number of significant frequencies in the data, the default value is set to 5. \cr
- polyorder: the polynomial regression component, the default odrer is set to 3. \cr
- freqs: set to a positive integer k returns a vector of k equally spaced frequencies in the Nyquist
  range. freqs can be provided as a vector of custom frequencies of interest. Set to 'internal'
  (the default value) generates a vector of equally spaced frequencies in the Nyquist range.
- n.cores: number of cores used in cross-validation. No value or 'MAX' applies all the available cores in computation.\cr}
}
\description{
\code{tuwrap} tuwrap compares results obtained from
 fitting multiple models of time-uncertain time series.
}
\examples{
# Note: Most of models included in tuts package are computationally intensive. In the example
# below I set parameters to meet CRAN’s testing requirement of maximum 5 sec per example.
# A more practical example would contain N=50 in the first line of the code and n.sim=10000.

#1. Import or simulate the data (a simulation is chosen for illustrative purposes):
DATA=simtuts(N=5,Harmonics=c(4,0,0), sin.ampl=c(10,0, 0), cos.ampl=c(0,0,0),
            trend=0,y.sd=2, ti.sd=0.2)
y=DATA$observed$y.obs
ti.mu=DATA$observed$ti.obs.tnorm
ti.sd= rep(0.2, length(ti.mu))

#2. Fit the models:
n.sim=100
WRAP=tuwrap(y=y,ti.mu=ti.mu,ti.sd=ti.sd,n.sim=n.sim,CV=FALSE,n.cores=2)

#3. Generate summary results:
summary(WRAP)

# Note: Accessing individual summaries, diagnostics and plots is presented in manuals
#       of models contained in the wrapper.SOme examples:

plot(WRAP$BFS,type='periodogram')
summary(WRAP$BFS,CI=0.99)

}
