% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c_additional_functions.r
\name{summary.tuts_wrap}
\alias{summary.tuts_wrap}
\title{Model comaprison of multiple time-uncertain models based on DIC criterion}
\usage{
\method{summary}{tuts_wrap}(object, ...)
}
\arguments{
\item{object}{A tuwrap object.}

\item{...}{optional arguments, not in use in the current version on tuts.}
}
\description{
\code{summary.tuts_wrap} function returns DIC criteria of multiple models contained in tuts_wrap objects.
}
\examples{
# Note: Most of models included in tuts package are computationally intensive. In the example
# below I set parameters to meet CRAN’s testing requirement of maximum 5 sec per example.
# A more practical example would contain N=50 in the first line of the code and n.sim=10000.

#1. Import or simulate the data (a simulation is chosen for illustrative purposes):
DATA=simtuts(N=5,Harmonics=c(4,0,0), sin.ampl=c(10,0, 0), cos.ampl=c(0,0,0),
            trend=0,y.sd=2, ti.sd=0.2)
y=DATA$observed$y.obs
ti.mu=DATA$observed$ti.obs.tnorm
ti.sd= rep(0.2, length(ti.mu))

#2. Fit the models:
n.sim=100
WRAP=tuwrap(y=y,ti.mu=ti.mu,ti.sd=ti.sd,n.sim=n.sim)

#3. Generate summary results:
summary(WRAP)

}
