% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_videocats.R
\name{list_videocats}
\alias{list_videocats}
\title{List of Categories That Can be Associated with Videos}
\usage{
list_videocats(filter = NULL, ...)
}
\arguments{
\item{filter}{string; Required.
named vector of length 1
potential names of the entry in the vector: 
\code{region_code}: Character. Required. Has to be a ISO 3166-1 alpha-2 code (see \url{https://www.iso.org/obp/ui/#search})
\code{category_id}: video category ID}

\item{\dots}{Additional arguments passed to \code{\link{tuber_GET}}.}
}
\value{
data.frame with 6 columns: \code{region_code, channelId, title, assignable, etag, id}
}
\description{
List of Categories That Can be Associated with Videos
}
\examples{
\dontrun{

# Set API token via yt_oauth() first

list_videocats(c(region_code = "JP"))
list_videocats() # Will throw an error asking for a valid filter with valid region_code
}
}
\references{
\url{https://developers.google.com/youtube/v3/docs/videoCategories/list}
}
