% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_video_details.R
\name{get_video_details}
\alias{get_video_details}
\title{Get Details of a Video or Videos}
\usage{
get_video_details(video_id = NULL, ...)
}
\arguments{
\item{video_id}{Comma separated list of IDs of the videos for which details are requested. Required.}

\item{\dots}{Additional arguments passed to \code{\link{tuber_GET}}.}
}
\value{
list with the following elements: \code{id} (video id that was passed), \code{publishedAt, channelId, title, description, thumbnails, 
channelTitle, categoryId, liveBroadcastContent, localized, defaultAudioLanguage}
}
\description{
Get details such as when the video was published, the title, description, thumbnails, category etc.
}
\examples{
\dontrun{

# Set API token via yt_oauth() first

get_video_details(video_id="yJXTXN4xrI8")
}
}
\references{
\url{https://developers.google.com/youtube/v3/docs/videos/list}
}
