% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_cp.R
\name{var_cp_test}
\alias{var_cp_test}
\title{Value at Risk CP Test}
\usage{
var_cp_test(actual, forecast, alpha, ...)
}
\arguments{
\item{actual}{a series representing the actual value of the series in the
out of sample period.}

\item{forecast}{the forecast values of the series at the quantile
given by alpha (the forecast value at risk).}

\item{alpha}{the quantile level used to calculate the forecast value at risk.}

\item{...}{not currently used.}
}
\value{
An object of class \dQuote{tstest.var_cp} which has a print and
as_flextable method.
}
\description{
The value at risk coverage and duration tests of
Kupiec (1995) and Christoffersen and Pelletier (1998,2004).
}
\details{
The unconditional (Kupiec 1995) and conditional (Christoffersen and
Pelletier 1998) coverage tests evaluate the correctness and independence of
value at risk violations (failures), individually and jointly. Correctness
is measured in terms of the expected and actual violations of value at risk
for a given quantile and data size, whilst independence checks the clustering
of violations with past violations, which is key in determining whether a model
can accurately capture the higher order dynamics of a series.
The duration of time between value ar risk violations (no-hits) should ideally
be independent and not cluster. Under the null hypothesis of a correctly
specified risk model, the no-hit duration should have no memory. Since the
only continuous distribution which is memory free is the exponential, the
test can conducted on any distribution which embeds the exponential as a
restricted case, and a likelihood ratio test then conducted to see whether
the restriction holds. Following Christoffersen and Pelletier (2004), the
Weibull distribution is used with parameter \sQuote{b=1} representing the case of
the exponential.
}
\examples{
library(tsdistributions)
data("garch_forecast")
q <- qdist("jsu", p = 0.05, mu = garch_forecast$forecast, sigma = garch_forecast$sigma,
skew = garch_forecast$skew, shape = garch_forecast$shape)
var_cp_test(actual = garch_forecast$actual, forecast = q, alpha = 0.05)

}
\references{
\insertRef{Kupiec1995}{tstests}

\insertRef{Christoffersen1998}{tstests}

\insertRef{Christoffersen2004}{tstests}
}
