% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hongli.R
\name{hongli_test}
\alias{hongli_test}
\title{The Non-Parametric Density Test of Hong and Li}
\usage{
hongli_test(x, lags = 4, conf_level = 0.95, ...)
}
\arguments{
\item{x}{a series representing the PIT transformed actuals given the forecast
values.}

\item{lags}{the number lags to use for testing the joint hypothesis.}

\item{conf_level}{the confidence level for generating the critical values
which serve as thresholds for deciding on the null hypothesis.}

\item{...}{none.}
}
\value{
An object of class \dQuote{tstest.hongli} which has a print and
\dQuote{as_flextable} method.
}
\description{
Implements the Non-Parametric Density Test of Hong and Li (2005).
}
\details{
A novel method to analyze how well a conditional density fits the underlying
data is through the probability integral transformation (PIT) discussed in
Rosenblatt (1952) and used in the \code{\link{berkowitz_test}}. Hong and Li (2005)
introduced a nonparametric portmanteau test, building on the work of
Ait-Sahalia (1996), which tests the joint hypothesis of i.i.d and uniformity
for a series of PIT transformed data. To achieve this, it tests for
misspecification in the conditional moments of the model transformed
standardized residuals, and is distributed as N(0, 1) under the null of a
correctly specified model. These moment tests are reported as \sQuote{M(1,1)}
to \sQuote{M(4,4)} in the output, with \sQuote{M(1,2)} related to
ARCH-in-mean effects, and \sQuote{M(2,1)} to leverage, while \sQuote{W} is the
Portmanteu type test statistic for general misspecification (using p lags)
and also distributed as N(0, 1) under the null of a correctly specified model.
Only upper tail critical values are used in this test. The interested reader
is referred to the paper for more details.
}
\examples{
library(tsdistributions)
data(garch_forecast)
x <- pdist('jsu', q = garch_forecast$actual, mu = garch_forecast$forecast,
sigma = garch_forecast$sigma, skew = garch_forecast$skew,
shape = garch_forecast$shape)
print(hongli_test(x), include.decision = TRUE)

}
\references{
\insertRef{Hong2005}{tstests}
}
