% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{garch_forecast}
\alias{garch_forecast}
\title{Sample GARCH Forecast Data}
\format{
\subsection{\code{garch_forecast}}{

A data.table with 250 rows and 5 columns:
\describe{
\item{date}{the forecast date}
\item{actual}{the realized values}
\item{forecast}{the forecast mu}
\item{sigma}{the forecast sigma}
\item{skew}{the estimated skew of the jsu distribution}
\item{shape}{the estimated shape of the jsu distribution}
}
}
}
\usage{
garch_forecast
}
\description{
A pre-computed backtest of the SPY log returns data
using a GARCH(1,1)-JSU model (see details for replication code).
}
\details{
The replication code for the backtest based 1-step ahead forecast distribution
is as follows:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(xts)
library(tsgarch)
data("spy", package = "tstests")
spyr <- na.omit(diff(log(spy)))
n <- NROW(spyr)
spec <- garch_modelspec(spyr, model = "garch", constant = T,
distribution = "jsu")
b <- tsbacktest(spec, start = (n - 250), end = n, h = 1, estimate_every = 30,
rolling = T, trace = T)
garch_forecast <- data.table(date = b$table$forecast_date,
actual = b$table$actual, forecast = b$table$mu, sigma = b$table$sigma,
skew = b$table$skew, shape = b$table$shape)
}\if{html}{\out{</div>}}
}
\keyword{datasets}
