% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as-tsibble.R
\name{update_tsibble}
\alias{update_tsibble}
\title{Update key and index for a tsibble}
\usage{
update_tsibble(
  x,
  key,
  index,
  regular = is_regular(x),
  validate = TRUE,
  .drop = key_drop_default(x)
)
}
\arguments{
\item{x}{A tsibble.}

\item{key}{Variable(s) that uniquely determine time indices. \code{NULL} for
empty key, and \code{c()} for multiple variables. It works with tidy selector
(e.g. \code{\link[dplyr:reexports]{dplyr::starts_with()}}).}

\item{index}{A variable to specify the time index variable.}

\item{regular}{Regular time interval (\code{TRUE}) or irregular (\code{FALSE}). The
interval is determined by the greatest common divisor of index column, if \code{TRUE}.}

\item{validate}{\code{TRUE} suggests to verify that each key or each combination
of key variables leads to unique time indices (i.e. a valid tsibble). If you
are sure that it's a valid input, specify \code{FALSE} to skip the checks.}

\item{.drop}{If \code{TRUE}, empty key groups are dropped.}
}
\description{
Update key and index for a tsibble
}
\details{
Unspecified arguments will inherit the attributes from \code{x}.
}
\examples{
# update index
library(dplyr)
pedestrian \%>\%
  group_by_key() \%>\%
  mutate(Hour_Since = Date_Time - min(Date_Time)) \%>\%
  update_tsibble(index = Hour_Since)

# update key: drop the variable "State" from the key
tourism \%>\% 
  update_tsibble(key = c(Purpose, Region))
}
