% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecasting.R
\name{grnn_forecasting}
\alias{grnn_forecasting}
\title{Time series forecasting using GRNN regression}
\usage{
grnn_forecasting(
  timeS,
  h,
  lags = NULL,
  sigma = "ROLLING",
  msas = c("recursive", "MIMO"),
  transform = c("multiplicative", "additive", "none")
)
}
\arguments{
\item{timeS}{A numeric vector or time series of class \code{ts}.}

\item{h}{A positive integer. Number of periods for forecasting.}

\item{lags}{An integer vector in increasing order expressing the lags used as
autoregressive variables. If NULL (the default) the lags are selected in a
fast, heuristic way. It is also possible to use the values \code{"FS"} and
\code{"BE"}, in which case, the lags are selected using forward selection
or backward elimination respectively. These techniques are feature
selection approaches.}

\item{sigma}{A positive real value or a character value. The smoothing
parameter in GRNN regression. Two character values are possible, "ROLLING"
(the default) and "FIXED", in which case the parameter is chosen using an
optimization tool with rolling origin evaluation or fixed origin
evaluation.}

\item{msas}{A string indicating the Multiple-Step Ahead Strategy used when
more than one value is predicted. It can be "MIMO" or "recursive" (the
default).}

\item{transform}{A character value indicating whether the training samples
are transformed. If the time series has a trend it is recommended. By
default is \code{"multiplicative"} (multiplicative transformation). It is also
possible a multiplicative transformation or no transformation.}
}
\value{
An object of class \code{"grnnForecast"}. The function
  \code{\link[base]{summary}} can be used to obtain or print a summary of the
  results. An object of class \code{"gnnForecast"} is a list containing at
  least the following components:

  \item{\code{call}}{the matched call.} \item{\code{msas}}{the Multi-Step
  Ahead Strategy.} \item{\code{prediction}}{a time series with the forecast.}
  \item{\code{model}}{an object of class \code{"grnnModel"} with the GRNN
  model}
}
\description{
It applies GRNN regression to forecast the future values of a time series.
The lags used as autoregressive variables are set with the \code{lags}
parameter. If the user does not set the lags, these values are selected
automatically.
}
\examples{
pred <- grnn_forecasting(USAccDeaths, h = 12, lags = 1:12)
plot(pred)
}
