% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdqr.R
\name{dnig}
\alias{dnig}
\alias{pnig}
\alias{qnig}
\alias{rnig}
\title{Normal Inverse Gaussian Distribution}
\usage{
dnig(x, mu = 0, sigma = 1, skew = 0, shape = 1, log = FALSE)

pnig(q, mu = 0, sigma = 1, skew = 0, shape = 1, lower_tail = TRUE, log = FALSE)

qnig(p, mu = 0, sigma = 1, skew = 0, shape = 1, lower_tail = TRUE, log = FALSE)

rnig(n, mu = 0, sigma = 1, skew = 0, shape = 1)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mu}{mean.}

\item{sigma}{standard deviation.}

\item{skew}{skew parameter.}

\item{shape}{shape parameter.}

\item{log}{(logical) if TRUE, probabilities p are given as log(p).}

\item{lower_tail}{if TRUE (default), probabilities are \eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations.}
}
\value{
d gives the density, p gives the distribution function, q gives the quantile function
and r generates random deviates. Output depends on x or q length, or n for the random number
generator.
}
\description{
Density, distribution, quantile function and random number
generation for the normal inverse gaussian distribution generalized parameterized in 
terms of mean, standard deviation, skew and shape parameters.
}
