% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vtransforms.R
\name{stochinverse}
\alias{stochinverse}
\title{Stochastic inverse of a v-transform}
\usage{
stochinverse(x, v, tscopula = NULL, tol = .Machine$double.eps^0.75)
}
\arguments{
\item{x}{an object of class \linkS4class{Vtransform}.}

\item{v}{a vector, matrix or time series with values in [0, 1].}

\item{tscopula}{a time series copula object.}

\item{tol}{the desired accuracy (convergence tolerance) that is passed to
\code{uniroot} if numerical inversion is used.}
}
\value{
A vector, matrix or time series with values in [0, 1].
}
\description{
Stochastic inverse of a v-transform
}
\examples{
stochinverse(Vsymmetric(), c(0, 0.25, 0.5, 0.75, 1))
}
