% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setar.gen.R
\name{setar.sim}
\alias{setar.sim}
\alias{setar.boot}
\alias{linear.boot}
\alias{linear.sim}
\title{Simulation and bootstrap of Threshold Autoregressive model (SETAR)}
\usage{
setar.boot(
  setarObject,
  boot.scheme = c("resample", "resample_block", "wild1", "wild2", "check"),
  seed = NULL,
  ...
)

linear.boot(
  linearObject,
  boot.scheme = c("resample", "resample_block", "wild1", "wild2", "check"),
  seed = NULL,
  ...
)

setar.sim(
  B,
  n = 200,
  lag = 1,
  include = c("const", "trend", "none", "both"),
  nthresh = 1,
  Thresh,
  starting = NULL,
  innov = rnorm(n),
  ...
)

linear.sim(
  B,
  n = 200,
  lag = 1,
  include = c("const", "trend", "none", "both"),
  starting = NULL,
  innov = rnorm(n),
  ...
)
}
\arguments{
\item{setarObject}{Bootstrap: the \code{\link{setar}} object to resample data from.}

\item{boot.scheme}{Bootstrap: which resampling scheme to use for the residuals. See \code{\link{resample_vec}}.}

\item{seed}{Bootstrap: seed used in the resampling}

\item{\dots}{additional arguments for the unexported \code{setar.gen}.}

\item{linearObject}{Bootstrap: the \code{\link{linear}} object to resample data from.}

\item{B}{Simulation: vector of coefficients to simulate from.}

\item{n}{Simulation: Number of observations to simulate.}

\item{Thresh, nthresh, lag, include}{Simulation: parameters for the SETAR to simulate. 
See \code{\link{setar}} for their description.}

\item{starting}{Simulation: Starting values (same length as lag)}

\item{innov}{Simulation: time series of innovations/residuals.}
}
\value{
a list with the simulated/bootstrapped data and the parameter matrix
used.
}
\description{
Simulate or bootstrap a Threshold AR (SETAR)
The \code{setar.sim} function allows to simulate a SETAR model from scratch. 
The most important argument is the \code{B} argument, which should be a one row matrix, 
with first the constant/trend arguments, then the 
slope coefficients, and this for each regime (lower, middle, high). 
Other arguments such as \code{lag}, \code{nthresh} indicate the dimension of this matrix. 
As an example, a SETAR with 2 lags, 1 threshold, a constant, would have coefficient in the order:
\code{c(const_L, phi_1_L, phi_2_L, const_H, phi_1_H, phi_2_H)} where L is for Lower regime, H for Higher. 

\code{setar.boot} on the other side resample/bootstraps an existing setar output. 
It uses a recursive approach, reconstructing the series. 
Residuals from the original model are resampled using different bootstrap schemes, see  \code{\link{resample_vec}}.
}
\examples{

##Simulation of a TAR with 1 threshold
TvarMat <- c(2.9,-0.4,-0.1,-1.5, 0.2,0.3)
sim<-setar.sim(B=TvarMat,lag=2, type="simul", nthresh=1, Thresh=2, starting=c(2.8,2.2))
mean(ifelse(sim>2,1,0))	#approximation of values over the threshold

#check the result
selectSETAR(sim, m=2)

##Bootstrap a TAR with two threshold (three regimes)
sun <- (sqrt(sunspot.year+1)-1)*2
sun_est <- setar(sun, nthresh=2, m=2)
sun_est_boot <- setar.boot(sun_est)
head(sun_est_boot)

##Check the bootstrap: with no resampling, is it the same series?
sun_est_boot <- setar.boot(sun_est, boot.scheme = "check")
all.equal(as.numeric(sun), sun_est_boot)

}
\seealso{
\code{\link{SETAR}} to estimate a SETAR, \code{\link{arima.sim}} to
simulate an ARMA.
}
\author{
Matthieu Stigler
}
\keyword{ts}
