% Generated by roxygen2 (4.0.2): do not edit by hand
\name{hbc.f}
\alias{hbc.f}
\alias{hbc.f.dense}
\alias{hbc.grad}
\alias{hbc.grad.dense}
\alias{hbc.hess.struct}
\title{Functions for hierarchical binary choice example}
\usage{
hbc.f(pars, Y, X, inv.Omega, inv.Sigma, T)

hbc.grad(pars, Y, X, inv.Omega, inv.Sigma, T)

hbc.f.dense(pars, Y, X, inv.Omega, T)

hbc.grad.dense(pars, Y, X, inv.Omega, T)

hbc.hess.struct(N, k)
}
\arguments{
\item{pars}{input parameters.}

\item{Y,X}{data}

\item{inv.Sigma,inv.Omega}{prior parameters}

\item{T}{number of observations per unit}

\item{N}{number of individual units}

\item{k}{length of individual parameter vector}

\item{...}{Additional arguments}
}
\description{
Functions that define the objective functions, gradients
and Hessian structures for the hierarchical binary choice example.
}
\details{
These are functions that define the objective functions and gradients for the
  demo examples in the vignette.
}
\references{
Braun, Michael.  2014.  trustOptim:  An R Package for Trust Region
Optimization with Sparse Hessians. Journal of Statistical Software 60(4),
1-16. www.jstatsoft.org/v60/i04/.
}

