% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retailer.R
\name{retailer_products}
\alias{retailer_products}
\title{Products for a specific retailer}
\usage{
retailer_products(
  retailer_id,
  product = NA,
  brand = NA,
  regex = TRUE,
  ignore_case = TRUE,
  head = FALSE,
  ...
)
}
\arguments{
\item{retailer_id}{A retailer ID.}

\item{product}{Filter by product name (treated as a regular expression).}

\item{brand}{Filter by product brand (treated as a regular expression).}

\item{regex}{Should filter be treated as a Regular Expression?}

\item{ignore_case}{Should case be ignore?}

\item{head}{Return the data (\code{FALSE}) or the number of records (\code{TRUE})?}

\item{...}{Arguments passed through to \code{paginate()}.}
}
\value{
Product details as a \code{data.frame} if \code{head} is \code{FALSE}, otherwise the number of products that would be returned.
}
\description{
Products for a specific retailer
}
\examples{
# Get products for a specific retailer.
\dontrun{
retailer_products(1)
retailer_products(9, product = "Nescafe")
retailer_products(9, product = "Nescafe", head = TRUE)
}
}
