% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_troopdata.R
\name{get_troopdata}
\alias{get_troopdata}
\title{Function to retrieve customized U.S. troop deployment data}
\usage{
get_troopdata(host = NA, branch = FALSE, startyear, endyear)
}
\arguments{
\item{host}{The Correlates of War (COW) numeric country code or ISO3C code for the host country or countries in the series}

\item{branch}{Logical. Should the function return a single vector containing total troop values or multiple vectors containing total values and values for individual branches? Default is FALSE.}

\item{startyear}{The first year for the series}

\item{endyear}{The last year for the series}
}
\value{
\code{get_troopdata()} returns a data frame containing country-year observations for U.S. troop deployments.
}
\description{
\code{get_troopdata()} generates a customized data frame containing country-year observations of U.S. military deployments overseas.
}
\examples{

\dontrun{
library(tidyverse)
library(troopdata)

example <- get_troopdata(host = NA, branch = TRUE, startyear = 1980, endyear = 2015)

head(example)

}

}
\references{
Tim Kane. Global U.S. troop deployment, 1950-2003. Technical Report. Heritage Foundation, Washington, D.C.

Michael A. Allen, Michael E. Flynn, and Carla Martinez Machain. 2021. "Global U.S. military deployment data: 1950-2020." Working Paper.
}
\author{
Michael E. Flynn
}
