% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/careful_escalation.R
\name{careful_escalation}
\alias{careful_escalation}
\title{Dose selection function that practices careful escalation.}
\usage{
careful_escalation(
  dose_finding_fit,
  tox_threshold,
  certainty_threshold,
  reference_dose = 1,
  start_dose = 1
)
}
\arguments{
\item{dose_finding_fit}{Instance of \code{\link{dose_finding_fit}}.}

\item{tox_threshold}{numeric, the toxicity threshold.}

\item{certainty_threshold}{numeric, the required confidence that the risk of
toxicity exceeds `tox_threshold` to advocate stopping.}

\item{reference_dose}{the integer index of the reference dose. 1 by default,
i.e. the lowest dose-level.}

\item{start_dose}{the integer index of the desired starting dose. 1 by
default. This is required for the function to give the desired answer when
no patients have yet been treated.}
}
\value{
an integer dose-level
}
\description{
Dose selection function that avoids dose-skipping in escalation and
advocates stopping when there is sufficient evidence that the risk of
toxicity at a reference dose exceeds some threshold.
}
\examples{
\dontrun{
# CRM example
fit <- stan_crm('1N 2N 3T', skeleton = c(0.1, 0.2, 0.35, 0.6),
                target = 0.2, model = 'empiric', beta_sd = 1,
                seed = 123)
}
}
