% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_peps2.R
\name{stan_peps2}
\alias{stan_peps2}
\title{Fit the P2TNE model developed for the PePS2 trial to some outcomes.}
\usage{
stan_peps2(eff, tox, cohorts, alpha_mean = -2.2, alpha_sd = 2,
  beta_mean = -0.5, beta_sd = 2, gamma_mean = -0.5, gamma_sd = 2,
  zeta_mean = -0.5, zeta_sd = 2, lambda_mean = -2.2, lambda_sd = 2,
  psi_mean = 0, psi_sd = 1, ...)
}
\arguments{
\item{eff}{A vector of efficacy outcomes for the patients, where 1=efficacy
and 0=no efficacy.}

\item{tox}{A vector of toxicity outcomes for the patients, where 1=toxicity
and 0=no toxicity.}

\item{cohorts}{A vector of integers from 1 to 6, denoting the cohorts to
which the patients belong.}

\item{alpha_mean}{The prior mean of alpha. Alpha is the efficacy model
intercept.}

\item{alpha_sd}{The prior standard deviation of alpha. Alpha is the efficacy
model  intercept.}

\item{beta_mean}{The prior mean of beta. Beta is the efficacy model term
for being previously treated.}

\item{beta_sd}{The prior standard deviation of beta. Beta is the efficacy
model term for being previously treated.}

\item{gamma_mean}{The prior mean of gamma. Gamma is the efficacy model term
for being PD-L1 score = Low.}

\item{gamma_sd}{The prior standard deviation of gamma. Gamma is the efficacy
model term for being PD-L1 score = Low.}

\item{zeta_mean}{The prior mean of zeta. Zeta is the efficacy model term
for being PD-L1 score = Medium.}

\item{zeta_sd}{The prior standard deviation of zeta. Zeta is the efficacy
model term for being PD-L1 score = Medium.}

\item{lambda_mean}{The prior mean of lambda. Lambda is the toxicity model
intercept.}

\item{lambda_sd}{The prior standard deviation of lambda. Lambda is the
toxicity model intercept.}

\item{psi_mean}{The prior mean of psi. Psi is the joint model association
parameter.}

\item{psi_sd}{The prior standard deviation of psi. Psi is the joint model
association parameter.}

\item{...}{Extra parameters are passed to \code{rstan::sampling}. Commonly
used options are \code{iter}, \code{chains}, \code{warmup}, \code{cores}, and
\code{control}.}
}
\value{
Object of class \code{\link[rstan:stanfit]{rstan::stanfit}} returned
by \code{\link[rstan:sampling]{rstan::sampling}}
}
\description{
The PePS2 trial
investigates pembrolizumab in non-small-cell lung cancer. Patients may be
previously treated (PT) or treatment naive (TN). Response rates in
lung cancer have been shown to increase with PD-L1 tumour proportion score.
PD-L1 score is measured at baseline. Each patient belongs to one of the
categories <1%, 1-49% or >=50%. PT vs TN status and PD-L1 category jointly
stratify the patient
population and are used as predictive variables to stratify the analysis.
The BEBOP model studies co-primary efficacy and toxicity outcomes in the
presence of predictive data. Thus, PePS2 studies efficacy and toxicity in
6 distinct cohorts:
TN Low, TN Medium, TN High, PT Low, PT Medium, PT High.
The design admits all-comers and does not target specific sample sizes in the
individual cohorts.
Hyperprior parameters have defaults to match those used in PePS2, but all may
be overridden.
The returned object includes randomly-sampled outcomes, as well as parameters
to run the model. These are all combined in the same list object for passing
to RStan, as is the convention.
See the accompanying vignette for a full description.
}
\examples{
\dontrun{
fit <- stan_peps2(
  eff = c(0, 1, 0, 1, 0, 0),
  tox = c(0, 0, 1, 1, 0, 0),
  cohorts = c(3, 1, 1, 4, 5, 6)
)
}
}
