% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mult.mk.test.R
\name{mult.mk.test}
\alias{mult.mk.test}
\alias{"Multiside}
\alias{Mann-Kendall}
\alias{Test"}
\title{Multivariate (Multisite) Mann-Kendall Test}
\usage{
mult.mk.test(x, alternative = c("two.sided", "greater", "less"))
}
\arguments{
\item{x}{a time series object of class "ts"}

\item{alternative}{the alternative hypothesis, defaults to \code{two.sided}}
}
\value{
An object with class "htest"

\item{data.name}{character string that denotes the input data}
\item{p.value}{the p-value for the entire series}
\item{statistic}{the z quantile of the standard normal distribution
for the entire series}
\item{null.value}{the null hypothesis}
\item{estimates}{the estimates S and varS for the entire series}
\item{alternative}{the alternative hypothesis}
\item{method}{character string that denotes the test}
\item{cov}{the variance - covariance matrix}
}
\description{
Performs a Multivariate (Multisite) Mann-Kendall test.
}
\details{
The Mann-Kendall scores are first computed for each variate (side)
seperately.

\deqn{
S = \sum_{k = 1}^{n-1} \sum_{j = k + 1}^n
\mathrm{sgn}\left(x_j - x_k\right)}{%
S = \sum_{k = 1}^{n-1} \sum_{j = k + 1}^n
sgn(x[j] - x[k])}

with \eqn{\mathrm{sgn}}{sgn} the signum function (see \code{\link{sign}}).

 The variance - covariance matrix is computed according to
 Libiseller and Grimvall (2002).

\deqn{
\Gamma_{xy} = \frac{1}{3}
\left[K + 4 \sum_{j=1}^n R_{jx} R_{jy} -
n \left(n + 1 \right) \left(n + 1 \right) \right]}

with

\deqn{
K = \sum_{1 \le i < j \le n} \mathrm{sgn} \left\{ \left( x_j - x_i \right)
\left( y_j - y_i \right) \right\}}

and

\deqn{
R_{jx} = \left\{ n + 1 + \sum_{i=1}^n
\mathrm{sgn} \left( x_j - x_i \right) \right\} / 2}

 Finally, the corrected z-statistics for the entire series
 is calculated as follows, whereas a continuity correction is employed
 for \eqn{n \le 10}{n <= 10}:

 \deqn{
 z = \frac{\sum_{i=1}^d S_i}{\sqrt{\sum_{j=1}^d \sum_{i=1}^d \Gamma_{ij}}}
 }{%
 z = sum(S) / sum(\Gamma)
 }

 where

 \eqn{z} denotes the quantile of the normal distribution
 \eqn{S} is the vector of Mann-Kendall scores
 for each variate (site) \eqn{1 \le i \le d}{1 <= i <= d} and
 \eqn{\Gamma} denotes symmetric variance - covariance matrix.
}
\note{
Ties are not corrected. Current Version is for complete observations only.
}
\examples{
data(hcb)
mult.mk.test(hcb)

}
\references{
Hipel, K.W. and McLeod, A.I. (1994),
\emph{Time Series Modelling of Water Resources and Environmental Systems}. 
New York: Elsevier Science.

Lettenmeier, D.P. (1988), Multivariate nonparametric tests for trend
in water quality. \emph{Water Resources Bulletin} 24, 505--512.

Libiseller, C. and Grimvall, A. (2002),
Performance of partial Mann-Kendall tests for trend detection in the
presence of covariates. \emph{Environmetrics} 13, 71--84,
\url{http://dx.doi.org/10.1002/env.507}.
}
\seealso{
\code{\link{cor}},
\code{\link{cor.test}},
\code{\link{mk.test}},
\code{\link{smk.test}}
}
\keyword{multivariate}
\keyword{nonparametric}
\keyword{ts}
