% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_fields.R
\name{update_card_field}
\alias{update_card_field}
\alias{update_card_checkbox}
\alias{update_card_date}
\alias{update_card_dropdown}
\alias{update_card_number}
\alias{update_card_text}
\alias{clear_card_field}
\title{Update card field value}
\usage{
update_card_field(card, field, key, value, ...)

update_card_checkbox(card, field, value, ...)

update_card_date(card, field, value, ...)

update_card_dropdown(card, field, value, ...)

update_card_number(card, field, value, ...)

update_card_text(card, field, value, ...)

clear_card_field(card, field, ...)
}
\arguments{
\item{card}{Card ID}

\item{field}{Custom field ID}

\item{key}{Key for the value, e.g. \code{"number"} or \code{"checked"}}

\item{value}{New value}

\item{...}{Additional arguments passed to \code{\link[=update_resource]{update_resource()}}}
}
\description{
Set custom field value on a single card.
}
\details{
\code{update_card_date} requires ISO Formatted Datetime String. \code{"YYYY-MM-DD"} is
fine, but if you want also hour and timezone, use \code{"YYYY-MM-DD hh:mm UTC+X"},
e.g. \code{"2018-12-24 16:00 UTC+1"}

\code{clear_card_field} does not remove the field, but replaces its value with
the equivalent of "No selection"
}
\seealso{
Other functions to handle custom fields: 
\code{\link{add_field_option}()},
\code{\link{add_field}()},
\code{\link{delete_field_option}()},
\code{\link{delete_field}()},
\code{\link{update_field}()}
}
\concept{functions to handle custom fields}
