% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noMargins.R
\name{noMargins}
\alias{noMargins}
\title{Remove Margins from Trellis/Lattice Plot}
\usage{
noMargins(..., topkey = FALSE, rightkey = FALSE)
}
\arguments{
\item{topkey}{should extra space be added for a top key?}

\item{rightkey}{should extra space be added for a right key?}

\item{\ldots}{a list of other parameters to be passed to par.settings}
}
\description{
Removes whitespace surrounding a trellis plot.  Ideal for \code{\link{makeDisplay}} because when tiling multiple panels, a lot of space is wasted with the margins.
}
\examples{
\dontrun{
library(lattice)
xyplot(c(1:10) ~ c(1:10) | sample(letters[1:2], 10, replace=TRUE),
  par.settings=noMargins()
)

# with additional par.settings...
xyplot(c(1:10) ~ c(1:10) | sample(letters[1:2], 10, replace = TRUE),
  par.settings = noMargins(
    list(plot.symbol = list(col = "black"))
  )
)
}

}
\seealso{
\code{\link[lattice]{xyplot}}, \code{\link{makeDisplay}}
}

