% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allTrees.R
\name{allTrees}
\alias{allTrees}
\title{Calculate all full unordered m-ary trees up to n tips}
\usage{
allTrees(n, m = 2, type = "real")
}
\arguments{
\item{n}{max number of tips}

\item{m}{max number of children for each node}

\item{type}{one of:
\describe{
  \item{\dQuote{real}}{real coefficient polynomials}
  \item{\dQuote{complex}}{complex coefficient polynomials (real polynomials with y = 1 + i)}
  \item{\dQuote{phylo}}{phylo objects}
}}
}
\value{
list of lists containing all the trees in \strong{type} format for each number of tips
}
\description{
Return real coefficient matrices, complex coefficient vectors, or phylo objects for all possible unordered full m-ary trees up to n tips.
For binary trees (m = 2), the number of trees at each number of tips follows the \href{https://oeis.org/A001190}{Wedderburn-Etherington numbers}.
}
\note{
only m = 2 is currently supported
}
\examples{
library(treenomial)
library(ape)

# generate coefficient matrices describing the polynomials of all possible
# unordered full binary trees up to 10 tips

allBinTenRealCoeff <- allTrees(10, type = "phylo")

# number of trees at each number of tips follows Wedderburn-Etherington numbers
lengths(allBinTenRealCoeff)

# phylo type example, plot all 6 tip unordered full binary trees

# backup par options
oldpar <- par(no.readonly =TRUE)

allBinSixPhylo <- allTrees(6, type = "phylo")[[6]]
par(mfrow=c(1,6))
plots <- lapply(allBinSixPhylo, function(t){
  plot.phylo(ladderize(t), direction = "downwards", show.tip.label = FALSE)
})

# restore par options
par(oldpar)

}
