% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-nds-methods.R
\name{getNdsSlt}
\alias{getNdsSlt}
\title{Get a node slot for multiple nodes}
\usage{
getNdsSlt(tree, slt_nm, ids, parallel = FALSE, progress = "none")
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{slt_nm}{slot name}

\item{ids}{vector of node ids}

\item{parallel}{logical, make parallel?}

\item{progress}{name of the progress bar to use, see \code{\link{create_progress_bar}}}
}
\description{
Returns the values of named slot as a vector for atomic values, else list.
}
\details{
Returned object depends on name, either character, vector or numeric. Parallelizable.
Default node slots are: id, spn, prid, ptid and txnym.
}
\examples{
library(treeman)
tree <- randTree(10)
getNdsSlt(tree, slt_nm='spn', ids=tree['tips'])  # return spans of all tips
}
\seealso{
\code{\link{getNdSlt}}, 
\url{https://github.com/DomBennett/treeman/wiki/get-methods}
}
