% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-spcl-methods.R
\name{getBiprts}
\alias{getBiprts}
\title{Get the sets of labels for each bipartition in tree}
\usage{
getBiprts(tree, tips = tree@tips, root = TRUE, universal = FALSE)
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{tips}{vector of tips IDs to use for bipartitions}

\item{root}{Include the root for the bipartitions? Default TRUE.}

\item{universal}{Create a code for comparing between trees}
}
\description{
Returns a list of tip IDs for each branch in the tree. Options
allow the user to act as if the root is not present and to use a universal
code for comparing between trees.
}
\details{
Setting \code{root} to FALSE will ignore the bipartitions created by
the root. Setting \code{universal} to TRUE will return a vector of 0s and 1s,
not a list of tips. These codes will always begin with 1, and will allow for
the comparison of splits between trees as they do not have "chiralty", so to
speak.
}
\examples{
library(treeman)
tree <- randTree(10)
# get all of the tip IDs for each branch in the rooted tree
(getBiprts(tree))
# ignore the root and get bipartitions for unrooted tree
(getBiprts(tree, root = FALSE))
# use the universal code for comparing splits between trees
(getBiprts(tree, root = FALSE, universal = TRUE))
}
\seealso{
\code{\link{calcDstRF}}
}
